/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.dtrace.recorder.DTraceMBean;
import com.jrockit.mc.dtrace.recorder.DTraceRecorder;
import com.jrockit.mc.dtrace.recorder.DTraceRecorderException;
import com.jrockit.mc.dtrace.recorder.RecorderConstants;
import com.jrockit.mc.dtrace.recorder.internal.local.LocalRecorder;
import com.jrockit.mc.dtrace.recorder.internal.mockup.Mockup;
import com.jrockit.mc.dtrace.recorder.internal.mockup.MockupRecorder;
import com.jrockit.mc.dtrace.recorder.internal.remote.DTrace;
import com.jrockit.mc.dtrace.recorder.internal.remote.RemoteRecorder;
import java.io.Closeable;
import java.io.InputStream;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;

public final class Factory {
    public static DTraceRecorder createMockupDTraceRecorder() {
        InputStream is = Factory.class.getClassLoader().getResourceAsStream("mockup/mockup.xml");
        try {
            Mockup mockup = (Mockup)PersistenceToolkit.createObjectFromInputStream(Mockup.class, (InputStream)is);
            MockupRecorder mockupRecorder = new MockupRecorder(mockup, "mockup/newRecording.clf");
            return mockupRecorder;
        }
        finally {
            IOToolkit.closeSilently((Closeable)is);
        }
    }

    public static DTraceRecorder createDTraceRecorder() {
        return new LocalRecorder();
    }

    public static DTraceMBean createDTraceMBean(DTraceRecorder recorder) {
        try {
            return new DTrace(recorder);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException(e);
        }
    }

    public static DTraceRecorder createRemoteDTraceRecorder(MBeanServerConnection server) throws DTraceRecorderException {
        RemoteRecorder recorder = new RemoteRecorder(server, RecorderConstants.MBEAN_OBJECT_NAME);
        try {
            if (recorder.getSetupState().booleanValue()) {
                return recorder;
            }
        }
        catch (Exception e) {
            throw new DTraceRecorderException("Remote machine not setup correctly for running DTrace.", e);
        }
        throw new DTraceRecorderException("Remote machine not setup correctly for running DTrace.");
    }
}

