/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder;

import com.jrockit.mc.dtrace.recorder.DTraceMBean;
import com.jrockit.mc.dtrace.recorder.DTraceRecorder;
import com.jrockit.mc.dtrace.recorder.Factory;
import com.jrockit.mc.dtrace.recorder.RecorderConstants;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;

public final class Application {
    public static void main(String[] args) {
        try {
            DTraceRecorder recorder = Application.createRecorder(args);
            if (recorder != null) {
                Application.startServer(recorder);
            } else {
                Application.printHelp();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static DTraceRecorder createRecorder(String[] args) throws IOException {
        if (args.length == 1 && "-mockup".equalsIgnoreCase(args[0])) {
            return Factory.createMockupDTraceRecorder();
        }
        return Factory.createDTraceRecorder();
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println("[-mockup mockup.xml newRecording.clf]");
    }

    private static void startServer(DTraceRecorder recorder) throws Exception {
        DTraceMBean dBean = Factory.createDTraceMBean(recorder);
        MBeanServer mBeanserver = ManagementFactory.getPlatformMBeanServer();
        mBeanserver.registerMBean(dBean, RecorderConstants.MBEAN_OBJECT_NAME);
        System.out.println("DTrace Remote Recorder Server started. Press S to stop.");
        int key = 0;
        while (!Application.isStopKey(key = System.in.read())) {
        }
        System.out.println("Shutting down.");
        mBeanserver.unregisterMBean(RecorderConstants.MBEAN_OBJECT_NAME);
    }

    private static boolean isStopKey(int key) {
        return key == 115 || key == 83;
    }
}

