/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.support.RefChainElement;
import com.oracle.joverflow.ui.model.ModelListener;
import com.oracle.joverflow.ui.model.ObjectCluster;
import com.oracle.joverflow.ui.viewers.ReferrerItemBuilder;
import com.oracle.joverflow.ui.viewers.ReferrerTable;
import javafx.scene.control.TableView;
import javafx.util.Callback;

public class ReferrerViewer
implements ModelListener {
    private ReferrerTable ui;
    private ReferrerItemBuilder builder;
    boolean start = true;
    private Callback<RefChainElement, Boolean> filter = new Callback<RefChainElement, Boolean>(){

        public Boolean call(RefChainElement param) {
            if (((ReferrerViewer)ReferrerViewer.this).ui.selectedItem != null && !((ReferrerViewer)ReferrerViewer.this).ui.selectedItem.check(param)) {
                return false;
            }
            return true;
        }
    };

    public ReferrerViewer(Runnable updateCallback) {
        this.ui = new ReferrerTable(updateCallback);
    }

    @Override
    public void allIncluded() {
        if (this.builder == null) {
            this.ui.getItems().clear();
        } else {
            this.ui.set(this.builder.buildReferrerList());
            this.builder = null;
        }
    }

    @Override
    public void include(ObjectCluster oc, RefChainElement ref) {
        if (this.builder == null) {
            this.builder = new ReferrerItemBuilder(oc, ref);
        } else {
            this.builder.addCluster(oc, ref);
        }
    }

    public TableView<?> getUi() {
        return this.ui;
    }

    public Callback<RefChainElement, Boolean> getFilter() {
        return this.filter;
    }

    public void reset() {
        this.ui.selectedItem = null;
    }
}

