/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.ui.viewers.CellFactories;
import com.oracle.joverflow.ui.viewers.ReferrerItem;
import com.sun.javafx.binding.ObjectConstant;
import java.util.Comparator;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Polygon;
import javafx.util.Callback;

class ReferrerTable
extends TableView<ReferrerItem> {
    private static final String HIGHLIGHT = "highlight";
    ReferrerItem selectedItem;
    private Callback<TableColumn.CellDataFeatures<ReferrerItem, ReferrerItem>, ObservableValue<ReferrerItem>> cellValFactory = new Callback<TableColumn.CellDataFeatures<ReferrerItem, ReferrerItem>, ObservableValue<ReferrerItem>>(){

        public ObservableValue<ReferrerItem> call(TableColumn.CellDataFeatures<ReferrerItem, ReferrerItem> param) {
            return ObjectConstant.valueOf((Object)((ReferrerItem)param.getValue()));
        }
    };

    public ReferrerTable(final Runnable updateCallback) {
        this.setRowFactory((Callback)new Callback<TableView<ReferrerItem>, TableRow<ReferrerItem>>(){

            public TableRow<ReferrerItem> call(TableView<ReferrerItem> param) {
                TableRow<ReferrerItem> row = new TableRow<ReferrerItem>(){

                    protected void updateItem(ReferrerItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.getStyleClass().remove((Object)ReferrerTable.HIGHLIGHT);
                        if (!empty && (this).ReferrerTable.this.selectedItem != null && (this).ReferrerTable.this.selectedItem.getLevel() >= item.getLevel()) {
                            this.getStyleClass().add((Object)ReferrerTable.HIGHLIGHT);
                        }
                    }
                };
                row.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>((TableRow)row, updateCallback){
                    private final /* synthetic */ TableRow val$row;
                    private final /* synthetic */ Runnable val$updateCallback;
                    {
                        this.val$row = tableRow;
                        this.val$updateCallback = runnable;
                    }

                    public void handle(MouseEvent me) {
                        int i = this.val$row.getIndex();
                        if (i >= 0 && i < ReferrerTable.this.getItems().size()) {
                            switch (me.getButton()) {
                                case PRIMARY: {
                                    (this).ReferrerTable.this.selectedItem = (ReferrerItem)ReferrerTable.this.getItems().get(i);
                                    this.val$updateCallback.run();
                                    break;
                                }
                                case SECONDARY: {
                                    (this).ReferrerTable.this.selectedItem = null;
                                    this.val$updateCallback.run();
                                }
                            }
                        }
                        me.consume();
                    }
                });
                return row;
            }
        });
        final TableColumn tc = new TableColumn("Referrer");
        tc.setCellValueFactory(this.cellValFactory);
        tc.setPrefWidth(350.0);
        tc.setCellFactory((Callback)new Callback<TableColumn<ReferrerItem, ReferrerItem>, TableCell<ReferrerItem, ReferrerItem>>(){

            public TableCell<ReferrerItem, ReferrerItem> call(TableColumn<ReferrerItem, ReferrerItem> param) {
                return new TableCell<ReferrerItem, ReferrerItem>(){
                    StackPane iconPane = new StackPane();
                    {
                        Polygon p = new Polygon(new double[]{3.0, 0.0, 6.0, 6.0, 3.8, 6.0, 3.8, 9.2, 8.0, 9.2, 8.0, 10.5, 2.5, 10.5, 2.5, 6.0, 0.0, 6.0});
                        p.getStyleClass().add((Object)"referrer-icon");
                        this.iconPane.getChildren().add((Object)p);
                        this.iconPane.setAlignment(Pos.CENTER_RIGHT);
                    }

                    public void updateIndex(int i) {
                        super.updateIndex(i);
                        if (i >= 0 && i < ReferrerTable.this.getItems().size()) {
                            this.doUpdateContent((ReferrerItem)this.getTableView().getItems().get(i));
                        }
                    }

                    private void doUpdateContent(ReferrerItem item) {
                        this.setText(item.getName());
                        int level = item.getLevel();
                        this.iconPane.setPrefWidth(200.0 - 188.0 / ((double)level / 25.0 + 1.0));
                        ((Node)this.iconPane.getChildren().get(0)).setStyle(item.isBranch() ? "-fx-stroke: dodgerblue;" : "-fx-stroke: black;");
                        this.setGraphic((Node)this.iconPane);
                    }

                    protected void updateItem(ReferrerItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.doUpdateContent(item);
                        }
                    }
                };
            }
        });
        tc.setComparator((Comparator)new Comparator<ReferrerItem>(){

            @Override
            public int compare(ReferrerItem o1, ReferrerItem o2) {
                boolean revSort = tc.getSortType() == TableColumn.SortType.ASCENDING;
                int indexCompare = revSort ? o1.getLevel() - o2.getLevel() : o2.getLevel() - o1.getLevel();
                return indexCompare == 0 ? o2.getName().compareTo(o1.getName()) : indexCompare;
            }
        });
        this.getColumns().add((Object)tc);
        final TableColumn memoryColumn = new TableColumn("Memory KB");
        memoryColumn.setCellValueFactory(this.cellValFactory);
        memoryColumn.setPrefWidth(100.0);
        memoryColumn.setSortType(TableColumn.SortType.DESCENDING);
        memoryColumn.setCellFactory(CellFactories.getMemoryCellFactory());
        memoryColumn.setComparator((Comparator)new Comparator<ReferrerItem>(){

            @Override
            public int compare(ReferrerItem o1, ReferrerItem o2) {
                boolean revSort = memoryColumn.getSortType() == TableColumn.SortType.ASCENDING;
                int indexCompare = revSort ? o1.getLevel() - o2.getLevel() : o2.getLevel() - o1.getLevel();
                return indexCompare == 0 ? ReferrerTable.compareLongs(o2.getMemory(), o1.getMemory()) : indexCompare;
            }
        });
        this.getColumns().add((Object)memoryColumn);
        final TableColumn ovhdColumn = new TableColumn("Overhead KB");
        ovhdColumn.setCellValueFactory(this.cellValFactory);
        ovhdColumn.setPrefWidth(100.0);
        ovhdColumn.setCellFactory(CellFactories.getOvhdCellFactory());
        ovhdColumn.setComparator((Comparator)new Comparator<ReferrerItem>(){

            @Override
            public int compare(ReferrerItem o1, ReferrerItem o2) {
                boolean revSort = ovhdColumn.getSortType() == TableColumn.SortType.ASCENDING;
                int indexCompare = revSort ? o1.getLevel() - o2.getLevel() : o2.getLevel() - o1.getLevel();
                return indexCompare == 0 ? ReferrerTable.compareLongs(o2.getOvhd(), o1.getOvhd()) : indexCompare;
            }
        });
        this.getColumns().add((Object)ovhdColumn);
        final TableColumn sizeColumn = new TableColumn("Objects");
        sizeColumn.setCellValueFactory(this.cellValFactory);
        sizeColumn.setPrefWidth(100.0);
        sizeColumn.setCellFactory(CellFactories.getSizeCellFactory());
        sizeColumn.setComparator((Comparator)new Comparator<ReferrerItem>(){

            @Override
            public int compare(ReferrerItem o1, ReferrerItem o2) {
                boolean revSort = sizeColumn.getSortType() == TableColumn.SortType.ASCENDING;
                int indexCompare = revSort ? o1.getLevel() - o2.getLevel() : o2.getLevel() - o1.getLevel();
                return indexCompare == 0 ? ReferrerTable.compareLongs(o2.getSize(), o1.getSize()) : indexCompare;
            }
        });
        this.getColumns().add((Object)sizeColumn);
        this.getSortOrder().add((Object)memoryColumn);
        this.setMinWidth(400.0);
    }

    private static int compareLongs(long l1, long l2) {
        return l1 == l2 ? 0 : (l2 > l1 ? 1 : -1);
    }

    void set(List<ReferrerItem> items) {
        this.getItems().setAll(items);
        this.sort();
    }
}

