/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.support.RefChainElement;
import com.oracle.joverflow.ui.model.ObjectCluster;
import com.oracle.joverflow.ui.viewers.ReferrerItem;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

class ReferrerItemBuilder {
    private Map<String, ReferrerItem> itemsAtBranchingLevel = new IdentityHashMap<String, ReferrerItem>();
    private List<String> commonChain = new ArrayList<String>();
    private int commonCount;
    private long commonOverhead;
    private long commonMemory;
    private RefChainElement lastRef;

    public ReferrerItemBuilder(ObjectCluster oc, RefChainElement ref) {
        while (ref != null) {
            this.commonChain.add(ref.toString());
            ref = ref.getReferer();
        }
        this.commonOverhead += (long)oc.getOverhead();
        this.commonMemory += (long)oc.getMemory();
        this.commonCount += oc.getObjectCount();
        this.lastRef = null;
    }

    public void addCluster(ObjectCluster oc, RefChainElement ref) {
        if (ref != this.lastRef) {
            this.lastRef = ref;
            int commonDepth = 0;
            for (String referrerName : this.commonChain) {
                if (ref == null || !referrerName.equals(ref.toString())) {
                    this.commonChain = this.commonChain.subList(0, commonDepth);
                    this.itemsAtBranchingLevel.clear();
                    this.itemsAtBranchingLevel.put(referrerName, new ReferrerItem(this.commonChain, referrerName, this.commonMemory, this.commonOverhead, this.commonCount, true));
                    break;
                }
                ref = ref.getReferer();
                ++commonDepth;
            }
        } else {
            int i = 0;
            while (i < this.commonChain.size()) {
                ref = ref.getReferer();
                ++i;
            }
        }
        this.addObjectCluster(oc, ref);
    }

    private void addObjectCluster(ObjectCluster oc, RefChainElement ref) {
        this.commonOverhead += (long)oc.getOverhead();
        this.commonMemory += (long)oc.getMemory();
        this.commonCount += oc.getObjectCount();
        if (ref != null) {
            String referrerName = ref.toString();
            ReferrerItem branchingItem = this.itemsAtBranchingLevel.get(referrerName);
            if (branchingItem == null) {
                branchingItem = new ReferrerItem(this.commonChain, ref.toString());
                this.itemsAtBranchingLevel.put(referrerName, branchingItem);
            }
            branchingItem.addObjectCluster(oc);
        }
    }

    public List<ReferrerItem> buildReferrerList() {
        ArrayList<ReferrerItem> items = new ArrayList<ReferrerItem>();
        int commonDepth = 0;
        for (String r : this.commonChain) {
            items.add(new ReferrerItem(this.commonChain.subList(0, commonDepth), r, this.commonMemory, this.commonOverhead, this.commonCount, false));
            ++commonDepth;
        }
        items.addAll(this.itemsAtBranchingLevel.values());
        return items;
    }
}

