/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.support.RefChainElement;
import com.oracle.joverflow.ui.model.ObjectCluster;
import java.util.List;

class ReferrerItem {
    private long ovhd;
    private long memory;
    private int size;
    private String referrer;
    private boolean isBranch;
    private List<String> commonReferrers;

    public ReferrerItem(List<String> commonReferrers, String referrer, long memory, long overhead, int objectCount, boolean isBranch) {
        this.isBranch = isBranch;
        this.referrer = referrer;
        this.commonReferrers = commonReferrers;
        this.ovhd = overhead;
        this.memory = memory;
        this.size = objectCount;
    }

    public ReferrerItem(List<String> parentReferrers, String referrer) {
        this(parentReferrers, referrer, 0L, 0L, 0, true);
    }

    public void addObjectCluster(ObjectCluster oc) {
        this.ovhd += (long)oc.getOverhead();
        this.memory += (long)oc.getMemory();
        this.size += oc.getObjectCount();
    }

    boolean check(RefChainElement ref) {
        for (String parentRefName : this.commonReferrers) {
            if (ref == null || !parentRefName.equals(ref.toString())) {
                return false;
            }
            ref = ref.getReferer();
        }
        return ref != null && this.referrer.equals(ref.toString());
    }

    public boolean isBranch() {
        return this.isBranch;
    }

    public int getLevel() {
        return this.commonReferrers.size();
    }

    public long getOvhd() {
        return this.ovhd;
    }

    public long getMemory() {
        return this.memory;
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.referrer.toString();
    }
}

