/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.support.RefChainElement;
import com.oracle.joverflow.ui.model.ClusterType;
import com.oracle.joverflow.ui.model.ModelListener;
import com.oracle.joverflow.ui.model.ObjectCluster;
import com.oracle.joverflow.ui.viewers.MemoryStatisticsItem;
import com.oracle.joverflow.ui.viewers.MemoryStatisticsTable;
import java.util.Arrays;
import javafx.scene.Node;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class OverheadTypeViewer
implements ModelListener {
    private HBox ui = new HBox();
    private MemoryStatisticsTable<MemoryStatisticsItem> tv;
    private MemoryStatisticsItem[] items = new MemoryStatisticsItem[ClusterType.values().length];

    public OverheadTypeViewer(Runnable updateCallback) {
        this.tv = new MemoryStatisticsTable(updateCallback);
        HBox.setHgrow(this.tv, (Priority)Priority.ALWAYS);
        this.ui.getChildren().addAll((Object[])new Node[]{this.tv});
        ClusterType[] clusterTypeArray = ClusterType.values();
        int n = clusterTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClusterType t = clusterTypeArray[n2];
            this.items[t.ordinal()] = new MemoryStatisticsItem((Object)t, 0L, 0L, 0);
            ++n2;
        }
        this.reset();
    }

    public void reset() {
        this.tv.selectedItem = this.items[ClusterType.ALL_OBJECTS.ordinal()];
    }

    public TableView<?> getTable() {
        return this.tv;
    }

    @Override
    public void include(ObjectCluster oc, RefChainElement ref) {
        if (oc.getType() != null) {
            this.items[oc.getType().ordinal()].addObjectCluster(oc);
        }
    }

    @Override
    public void allIncluded() {
        this.tv.set(Arrays.asList(this.items));
        MemoryStatisticsItem[] memoryStatisticsItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryStatisticsItem i = memoryStatisticsItemArray[n2];
            i.reset();
            ++n2;
        }
    }

    public Node getUi() {
        return this.ui;
    }

    public ClusterType getCurrentType() {
        return (ClusterType)((Object)((MemoryStatisticsItem)this.tv.selectedItem).getId());
    }
}

