/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.ui.viewers.CellFactories;
import com.oracle.joverflow.ui.viewers.MemoryStatisticsItem;
import com.sun.javafx.binding.ObjectConstant;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class MemoryStatisticsTable<T extends MemoryStatisticsItem>
extends TableView<T> {
    private static final String HIGHLIGHT = "highlight";
    T selectedItem;

    public MemoryStatisticsTable(final Runnable updateCallback) {
        this.setRowFactory(new Callback<TableView<T>, TableRow<T>>(){

            public TableRow<T> call(TableView<T> param) {
                final TableRow row = new TableRow<T>(){

                    protected void updateItem(T item, boolean empty) {
                        super.updateItem(item, empty);
                        this.getStyleClass().remove((Object)MemoryStatisticsTable.HIGHLIGHT);
                        if (item == (this).MemoryStatisticsTable.this.selectedItem) {
                            this.getStyleClass().add((Object)MemoryStatisticsTable.HIGHLIGHT);
                        }
                    }
                };
                row.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent me) {
                        if (MemoryStatisticsTable.this.getItems().size() > row.getIndex()) {
                            switch (me.getButton()) {
                                case PRIMARY: 
                                case SECONDARY: {
                                    (this).MemoryStatisticsTable.this.selectedItem = (MemoryStatisticsItem)MemoryStatisticsTable.this.getItems().get(row.getIndex());
                                    updateCallback.run();
                                }
                            }
                        }
                        me.consume();
                    }
                });
                return row;
            }
        });
        TableColumn name = new TableColumn("Object Selection");
        name.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<T, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<T, String> param) {
                return ObjectConstant.valueOf((Object)((MemoryStatisticsItem)param.getValue()).getName());
            }
        });
        name.setPrefWidth(230.0);
        TableColumn memory = new TableColumn("Memory KB");
        memory.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<T, Number>, ObservableValue<Number>>(){

            public ObservableValue<Number> call(TableColumn.CellDataFeatures<T, Number> param) {
                return ((MemoryStatisticsItem)param.getValue()).memoryProperty();
            }
        });
        memory.setCellFactory(CellFactories.getMemoryCellFactory());
        memory.setPrefWidth(100.0);
        memory.setSortType(TableColumn.SortType.DESCENDING);
        TableColumn ovhd = new TableColumn("Overhead KB");
        ovhd.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<T, Number>, ObservableValue<Number>>(){

            public ObservableValue<Number> call(TableColumn.CellDataFeatures<T, Number> param) {
                return ((MemoryStatisticsItem)param.getValue()).ovhdProperty();
            }
        });
        ovhd.setCellFactory(CellFactories.getOvhdCellFactory());
        ovhd.setPrefWidth(100.0);
        TableColumn size = new TableColumn("Objects");
        size.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<T, Number>, ObservableValue<Number>>(){

            public ObservableValue<Number> call(TableColumn.CellDataFeatures<T, Number> param) {
                return ((MemoryStatisticsItem)param.getValue()).sizeProperty();
            }
        });
        size.setCellFactory(CellFactories.getSizeCellFactory());
        size.setPrefWidth(75.0);
        this.getSortOrder().add((Object)memory);
        this.getColumns().setAll((Object[])new TableColumn[]{name, memory, ovhd, size});
    }

    public void set(Iterable<T> items) {
        ArrayList<MemoryStatisticsItem> nonEmptyItems = new ArrayList<MemoryStatisticsItem>();
        for (MemoryStatisticsItem i : items) {
            if (!i.update()) continue;
            nonEmptyItems.add(i);
        }
        this.getItems().setAll(nonEmptyItems);
        this.sort();
    }
}

