/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.ui.model.ObjectCluster;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;

class MemoryStatisticsItem {
    private Object id;
    private Integer index;
    private LongProperty ovhdP = new SimpleLongProperty();
    private LongProperty memoryP = new SimpleLongProperty();
    private IntegerProperty sizeP = new SimpleIntegerProperty();
    private long ovhd;
    private long memory;
    private int size;

    public MemoryStatisticsItem(Object id, long memory, long ovhd, int size) {
        this.id = id;
        this.memoryP.set(memory);
        this.ovhdP.set(ovhd);
        this.sizeP.set(size);
    }

    public void reset() {
        this.ovhd = 0L;
        this.memory = 0L;
        this.size = 0;
    }

    public String getName() {
        return this.id == null ? "N/A" : this.id.toString();
    }

    public LongProperty ovhdProperty() {
        return this.ovhdP;
    }

    public LongProperty memoryProperty() {
        return this.memoryP;
    }

    public IntegerProperty sizeProperty() {
        return this.sizeP;
    }

    public void addObjectCluster(ObjectCluster oc) {
        this.ovhd += (long)oc.getOverhead();
        this.memory += (long)oc.getMemory();
        this.size += oc.getObjectCount();
    }

    public boolean update() {
        if (this.size == 0) {
            return false;
        }
        this.memoryP.set(this.memory);
        this.sizeP.set(this.size);
        this.ovhdP.set(this.ovhd);
        return true;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Object getId() {
        return this.id;
    }

    public String toString() {
        return this.getName();
    }
}

