/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.heap.model.JavaHeapObject;
import com.oracle.joverflow.heap.model.JavaThing;
import com.oracle.joverflow.support.RefChainElement;
import com.oracle.joverflow.ui.model.ModelListener;
import com.oracle.joverflow.ui.model.ObjectCluster;
import com.oracle.joverflow.ui.tabletree.TreeTable;
import com.oracle.joverflow.ui.viewers.JavaThingItem;
import com.oracle.joverflow.ui.viewers.JavaThingTree;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;

public abstract class JavaThingViewer
implements ModelListener {
    private static final int MAX = 500;
    private JavaThingTree ui = new JavaThingTree();
    private int[] objects = new int[500];
    private int objectsInArray;
    private int totalInstancesCount;

    @Override
    public void include(ObjectCluster oc, RefChainElement ref) {
        int insertCount = Math.min(oc.getObjectCount(), 500 - this.objectsInArray);
        int i = 0;
        while (i < insertCount) {
            this.objects[this.objectsInArray++] = oc.getGlobalObjectIndex(i);
            ++i;
        }
        this.totalInstancesCount += oc.getObjectCount();
    }

    @Override
    public void allIncluded() {
        LoadJavaThingsTask task = new LoadJavaThingsTask(Arrays.copyOf(this.objects, this.objectsInArray), this.totalInstancesCount);
        this.ui.itemsProperty().bind((ObservableValue)task.valueProperty());
        new Thread((Runnable)((Object)task)).start();
        this.objectsInArray = 0;
        this.totalInstancesCount = 0;
    }

    public TreeTable<?> getUi() {
        return this.ui;
    }

    protected abstract JavaHeapObject getObjectAtPostion(int var1);

    private class LoadJavaThingsTask
    extends Task<ObservableList<JavaThingItem>> {
        int[] objects;
        int noinstances;

        LoadJavaThingsTask(int[] objects, int noinstances) {
            this.objects = objects;
            this.noinstances = noinstances;
        }

        protected ObservableList<JavaThingItem> call() throws Exception {
            ArrayList<JavaThingItem> items = new ArrayList<JavaThingItem>();
            int[] nArray = this.objects;
            int n = this.objects.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                JavaHeapObject o = JavaThingViewer.this.getObjectAtPostion(i);
                items.add(new JavaThingItem(0, o.idAsString(), (JavaThing)o));
                ++n2;
            }
            if (this.noinstances > this.objects.length) {
                items.add(new JavaThingItem(0, "...", String.valueOf(this.noinstances - this.objects.length) + " more instances", 0, null){

                    @Override
                    String getSize() {
                        return "";
                    }
                });
            }
            return FXCollections.observableList(items);
        }
    }
}

