/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.heap.model.JavaField;
import com.oracle.joverflow.heap.model.JavaHeapObject;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.heap.model.JavaObjectArray;
import com.oracle.joverflow.heap.model.JavaThing;
import com.oracle.joverflow.heap.model.JavaValueArray;
import com.oracle.joverflow.ui.tabletree.TreeTable;
import com.oracle.joverflow.ui.viewers.JavaThingItem;
import com.sun.javafx.binding.ObjectConstant;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

class JavaThingTree
extends TreeTable<JavaThingItem> {
    JavaThingTree() {
        TableColumn tc = new TableColumn("Name");
        tc.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<JavaThingItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<JavaThingItem, String> param) {
                return ObjectConstant.valueOf((Object)((JavaThingItem)param.getValue()).getName());
            }
        });
        tc.setPrefWidth(350.0);
        this.addTreeColumn(tc);
        TableColumn value = new TableColumn("Value");
        value.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<JavaThingItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<JavaThingItem, String> param) {
                return ObjectConstant.valueOf((Object)((JavaThingItem)param.getValue()).getValue());
            }
        });
        value.setPrefWidth(350.0);
        this.getColumns().add((Object)value);
        value.setSortable(false);
        TableColumn sizeCol = new TableColumn("Size");
        sizeCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<JavaThingItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<JavaThingItem, String> param) {
                return ObjectConstant.valueOf((Object)((JavaThingItem)param.getValue()).getSize());
            }
        });
        sizeCol.setPrefWidth(100.0);
        this.getColumns().add((Object)sizeCol);
        sizeCol.setSortable(false);
        this.setPrefWidth(1010.0);
    }

    @Override
    protected boolean hasChildItems(JavaThingItem item) {
        JavaThing thing = item.getContent();
        return thing instanceof JavaObject && ((JavaObject)thing).getClazz().getFieldsForInstance().length > 0 || thing instanceof JavaObjectArray && ((JavaObjectArray)thing).getLength() > 0 || thing instanceof JavaValueArray && ((JavaValueArray)thing).getLength() > 0;
    }

    @Override
    protected Iterable<JavaThingItem> getChildItems(JavaThingItem item) {
        Iterable<JavaThingItem> childItems = item.getChildItems();
        if (childItems == null) {
            ArrayList<JavaThingItem> items = new ArrayList<JavaThingItem>();
            JavaThing thing = item.getContent();
            if (thing != null) {
                if (thing instanceof JavaObject) {
                    JavaObject o = (JavaObject)thing;
                    JavaField[] fields = o.getClazz().getFieldsForInstance();
                    JavaThing[] values = o.getFields();
                    int i = 0;
                    while (i < fields.length) {
                        items.add(new JavaThingItem(item.getLevel() + 1, fields[i].getName(), values[i]));
                        ++i;
                    }
                } else if (thing instanceof JavaObjectArray) {
                    JavaObjectArray o = (JavaObjectArray)thing;
                    int i = 0;
                    JavaHeapObject[] javaHeapObjectArray = o.getElements();
                    int n = javaHeapObjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JavaHeapObject th = javaHeapObjectArray[n2];
                        items.add(new JavaThingItem(item.getLevel() + 1, "[" + i++ + "]", (JavaThing)th));
                        ++n2;
                    }
                } else if (thing instanceof JavaValueArray) {
                    JavaValueArray o = (JavaValueArray)thing;
                    int i = 0;
                    String[] stringArray = o.getValuesAsStrings();
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String value = stringArray[n3];
                        items.add(new JavaThingItem(item.getLevel() + 1, "[" + i++ + "]", value, o.getElementSize(), null));
                        ++n3;
                    }
                }
            }
            item.setChildItems(items);
            childItems = items;
        }
        return childItems;
    }
}

