/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.heap.model.JavaThing;
import com.oracle.joverflow.ui.tabletree.TreeItem;

class JavaThingItem
implements TreeItem {
    private Iterable<JavaThingItem> children;
    private boolean expanded;
    private int level;
    private JavaThing content;
    private String name;
    private String value;
    private String size;

    public JavaThingItem(int level, String name, JavaThing content) {
        this(level, name, content == null ? "null" : content.valueAsString(), content == null ? 0 : content.getSize(), content);
    }

    public JavaThingItem(int level, String name, String value, int size, JavaThing content) {
        this.level = level;
        this.content = content;
        this.name = String.valueOf(name);
        this.value = String.valueOf(value);
        this.size = Integer.toString(size);
    }

    String getName() {
        return this.name;
    }

    String getValue() {
        return this.value;
    }

    String getSize() {
        return this.size;
    }

    public Iterable<JavaThingItem> getChildItems() {
        return this.children;
    }

    public void setChildItems(Iterable<JavaThingItem> children) {
        this.children = children;
    }

    @Override
    public void setExpended(boolean expanded) {
        this.expanded = expanded;
        if (!expanded && this.children != null) {
            for (TreeItem treeItem : this.children) {
                treeItem.setExpended(false);
            }
        }
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public JavaThing getContent() {
        return this.content;
    }
}

