/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.ui.fx.FxmlHelper;
import com.oracle.joverflow.ui.viewers.CellFactories;
import com.oracle.joverflow.ui.viewers.MemoryStatisticsItem;
import com.sun.javafx.binding.ObjectConstant;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.chart.PieChart;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;

public abstract class ItemPieChart<T extends MemoryStatisticsItem>
extends HBox {
    private DropShadow lowDropShadow = new DropShadow(BlurType.GAUSSIAN, Color.rgb((int)0, (int)0, (int)0, (double)0.4), 5.0, 0.0, 2.0, 2.0);
    private DropShadow highDropShadow = new DropShadow(BlurType.GAUSSIAN, Color.rgb((int)0, (int)0, (int)0, (double)0.4), 5.0, 0.0, 4.0, 4.0);
    private InnerShadow innerShadow = new InnerShadow(BlurType.GAUSSIAN, Color.rgb((int)0, (int)0, (int)0, (double)0.4), 7.0, 0.0, 3.0, 3.0);
    private static final String[] COLORS = new String[]{"#a9e200", "#f9d900", "#22bad9", "#0181e2", "#2f357f", "#860061", "#c62b00", "#ff5700"};
    private static final String OTHER_COLOR = "#cccccc";
    @FXML
    protected Label pieTitle;
    @FXML
    protected PieChart pie;
    @FXML
    protected TableView<T> legend;
    @FXML
    protected VBox pieContainer;
    private PieProperty currentProperty;
    private PieChart.Data othersItem = new PieChart.Data("", 0.0);
    private Map<T, PieChart.Data> pieItems = new HashMap<T, PieChart.Data>();
    private Set<T> nonPieItems = new HashSet<T>();
    private Set<T> legendItems = new HashSet<T>();
    private Map<Node, T> iconMap = new WeakHashMap<Node, T>();

    ItemPieChart(String title) {
        try {
            FxmlHelper.loadFromFxml(ItemPieChart.class.getResource("ItemPieChart.fxml"), (Object)this, (Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setPadding(new Insets(2.0));
        this.pieContainer.setPadding(new Insets(0.0, 4.0, 0.0, 0.0));
        this.pieContainer.setSpacing(3.0);
        this.pieTitle.getStyleClass().add((Object)"chart-title");
        this.pie.getData().add((Object)this.othersItem);
        this.initLegend();
        this.setTitle(title);
        this.updateNodeColor(this.othersItem.getNode(), OTHER_COLOR);
        this.othersItem.getNode().setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                switch (me.getButton()) {
                    case PRIMARY: {
                        ItemPieChart.this.onItemSecondaryAction(ItemPieChart.this.pieItems.keySet());
                        break;
                    }
                    case SECONDARY: {
                        ItemPieChart.this.onItemPrimaryAction(ItemPieChart.this.pieItems.keySet());
                    }
                }
            }
        });
        this.othersItem.getNode().setPickOnBounds(false);
        this.othersItem.getNode().hoverProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean isHovered) {
                ItemPieChart.this.updateNodeHover(ItemPieChart.this.othersItem.getNode(), isHovered);
                for (Map.Entry e : ItemPieChart.this.iconMap.entrySet()) {
                    if (!ItemPieChart.this.nonPieItems.contains(e.getValue())) continue;
                    ItemPieChart.this.updateNodeHover((Node)e.getKey(), isHovered);
                }
            }
        });
        this.addPressHandler(this.othersItem.getNode());
        this.pie.setLabelsVisible(false);
        this.pie.setLegendVisible(false);
    }

    void setTitle(String title) {
        this.pieTitle.setText(title);
        ((TableColumn)this.legend.getColumns().get(0)).setText(title);
    }

    void clear() {
        this.nonPieItems.clear();
        this.pieItems.clear();
        this.legendItems.clear();
        this.pie.getData().retainAll((Object[])new PieChart.Data[]{this.othersItem});
    }

    public TableView<T> getLegend() {
        return this.legend;
    }

    public Pane getDetailsPane() {
        return this.pieContainer;
    }

    public void onItemHovered(T item, boolean isHovered) {
        if (this.pieItems.containsKey(item)) {
            this.updateNodeHover(this.pieItems.get(item).getNode(), isHovered);
        } else {
            this.updateNodeHover(this.othersItem.getNode(), isHovered);
        }
        for (Map.Entry<Node, T> e : this.iconMap.entrySet()) {
            if (!((MemoryStatisticsItem)e.getValue()).equals(item)) continue;
            this.updateNodeHover(e.getKey(), isHovered);
        }
    }

    private void addUi(final T item) {
        PieChart.Data data = new PieChart.Data("", (double)this.getValue(item));
        data.pieValueProperty().bind(this.getProperty(item));
        this.pie.getData().add((Object)data);
        this.pieItems.put(item, data);
        EventHandler<MouseEvent> clickHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                switch (me.getButton()) {
                    case PRIMARY: {
                        ItemPieChart.this.onItemPrimaryAction(item);
                        break;
                    }
                    case SECONDARY: {
                        ItemPieChart.this.onItemSecondaryAction(item);
                    }
                }
            }
        };
        ChangeListener<Boolean> hoverHandler = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean isHovered) {
                ItemPieChart.this.onItemHovered(item, isHovered);
            }
        };
        this.updateNodeColor(data.getNode(), this.getColor(((MemoryStatisticsItem)item).getIndex()));
        this.updateNodeHover(data.getNode(), false);
        data.getNode().setPickOnBounds(false);
        data.getNode().setOnMouseClicked((EventHandler)clickHandler);
        data.getNode().hoverProperty().addListener((ChangeListener)hoverHandler);
        this.addPressHandler(data.getNode());
    }

    public void setContent(Iterable<T> items) {
        ArrayList<MemoryStatisticsItem> nonEmptyItems = new ArrayList<MemoryStatisticsItem>();
        for (MemoryStatisticsItem item : items) {
            if (!item.update()) continue;
            nonEmptyItems.add(item);
        }
        this.legend.getItems().setAll(nonEmptyItems);
        this.legend.sort();
    }

    void updatePie() {
        ArrayList sortedItems = new ArrayList(this.legend.getItems());
        Collections.sort(sortedItems, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ItemPieChart.this.getValue(o2) == ItemPieChart.this.getValue(o1) ? 0 : (ItemPieChart.this.getValue(o2) > ItemPieChart.this.getValue(o1) ? 1 : -1);
            }
        });
        double totalOther = 0.0;
        HashSet<T> removeItems = new HashSet<T>(this.pieItems.keySet());
        int i = 0;
        for (MemoryStatisticsItem item : sortedItems) {
            if (item.getIndex() == null) {
                item.setIndex(i);
            }
            if (i <= 12 && this.getValue(item) > 0L) {
                if (!this.pieItems.containsKey(item)) {
                    this.addUi(item);
                    this.nonPieItems.remove(item);
                    this.updateItemColor(item, this.getColor(item.getIndex()));
                }
                removeItems.remove(item);
            } else {
                totalOther += (double)this.getValue(item);
                if (!this.nonPieItems.contains(item)) {
                    this.nonPieItems.add(item);
                    this.updateItemColor(item, OTHER_COLOR);
                    PieChart.Data data = this.pieItems.remove(item);
                    if (data != null) {
                        this.pie.getData().remove((Object)data);
                    }
                }
            }
            ++i;
        }
        for (MemoryStatisticsItem item : removeItems) {
            PieChart.Data d = this.pieItems.remove(item);
            if (d == null) continue;
            this.pie.getData().remove((Object)d);
        }
        this.othersItem.setPieValue(totalOther);
    }

    private long getValue(T item) {
        switch (this.currentProperty) {
            case MEMORY: {
                return ((MemoryStatisticsItem)item).memoryProperty().get();
            }
            case OVERHEAD: {
                return ((MemoryStatisticsItem)item).ovhdProperty().get();
            }
            case COUNT: {
                return ((MemoryStatisticsItem)item).sizeProperty().get();
            }
        }
        throw new RuntimeException((Object)((Object)this.currentProperty) + " not handled");
    }

    private ObservableValue<? extends Number> getProperty(T item) {
        switch (this.currentProperty) {
            case MEMORY: {
                return ((MemoryStatisticsItem)item).memoryProperty();
            }
            case OVERHEAD: {
                return ((MemoryStatisticsItem)item).ovhdProperty();
            }
            case COUNT: {
                return ((MemoryStatisticsItem)item).sizeProperty();
            }
        }
        throw new RuntimeException((Object)((Object)this.currentProperty) + " not handled");
    }

    private void updateItemColor(T item, String color) {
        for (Map.Entry<Node, T> e : this.iconMap.entrySet()) {
            if (!((MemoryStatisticsItem)e.getValue()).equals(item)) continue;
            this.updateNodeColor(e.getKey(), color);
        }
    }

    private void updateNodeColor(Node n, String color) {
        if (n != null) {
            n.setStyle("-fx-pie-color: " + color + ";");
        }
    }

    private void updateNodeHover(Node n, boolean isHovered) {
        n.setScaleX(isHovered ? 1.08 : 1.0);
        n.setScaleY(isHovered ? 1.08 : 1.0);
        n.setEffect((Effect)(isHovered ? this.highDropShadow : this.lowDropShadow));
    }

    private void addPressHandler(final Node n) {
        n.pressedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean isPressed) {
                n.setEffect((Effect)(isPressed != false ? ItemPieChart.this.innerShadow : (n.isHover() ? ItemPieChart.this.highDropShadow : ItemPieChart.this.lowDropShadow)));
            }
        });
    }

    private void initLegend() {
        TableColumn name = new TableColumn("Name");
        name.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<T, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<T, String> param) {
                return ObjectConstant.valueOf((Object)((MemoryStatisticsItem)param.getValue()).getName());
            }
        });
        name.setCellFactory(new Callback<TableColumn<T, String>, TableCell<T, String>>(){

            public TableCell<T, String> call(TableColumn<T, String> param) {
                return new TableCell<T, String>(){
                    Region icon = new Region();
                    {
                        this.icon.getStyleClass().setAll((Object[])new String[]{"chart-pie", "chart-legend-item-symbol", "pie-legend-symbol"});
                        this.setGraphic((Node)this.icon);
                        ItemPieChart.this.updateNodeHover((Node)this.icon, false);
                    }

                    public void updateIndex(int i) {
                        if (i >= 0 && i < this.getTableView().getItems().size() && i != this.getIndex()) {
                            this.doUpdateContent(i);
                        }
                        super.updateIndex(i);
                    }

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!empty) {
                            this.doUpdateContent(this.getIndex());
                        } else {
                            this.setText(null);
                            this.setGraphic(null);
                        }
                    }

                    private void doUpdateContent(int i) {
                        MemoryStatisticsItem item = (MemoryStatisticsItem)this.getTableView().getItems().get(i);
                        ItemPieChart.this.iconMap.put(this.icon, item);
                        ItemPieChart.this.updateNodeColor((Node)this.icon, ItemPieChart.this.pieItems.containsKey(item) ? ItemPieChart.this.getColor(item.getIndex()) : ItemPieChart.OTHER_COLOR);
                        this.setText(item.getName());
                        this.setGraphic((Node)this.icon);
                    }
                };
            }
        });
        name.setPrefWidth(215.0);
        final TableColumn memory = new TableColumn("Memory KB");
        memory.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<T, Number>, ObservableValue<Number>>(){

            public ObservableValue<Number> call(TableColumn.CellDataFeatures<T, Number> param) {
                return ((MemoryStatisticsItem)param.getValue()).memoryProperty();
            }
        });
        memory.setCellFactory(CellFactories.getMemoryCellFactory());
        memory.setPrefWidth(90.0);
        memory.setSortType(TableColumn.SortType.DESCENDING);
        final TableColumn ovhd = new TableColumn("Overhead KB");
        ovhd.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<T, Number>, ObservableValue<Number>>(){

            public ObservableValue<Number> call(TableColumn.CellDataFeatures<T, Number> param) {
                return ((MemoryStatisticsItem)param.getValue()).ovhdProperty();
            }
        });
        ovhd.setCellFactory(CellFactories.getOvhdCellFactory());
        ovhd.setPrefWidth(100.0);
        final TableColumn size = new TableColumn("Objects");
        size.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<T, Number>, ObservableValue<Number>>(){

            public ObservableValue<Number> call(TableColumn.CellDataFeatures<T, Number> param) {
                return ((MemoryStatisticsItem)param.getValue()).sizeProperty();
            }
        });
        size.setCellFactory(CellFactories.getSizeCellFactory());
        size.setPrefWidth(75.0);
        this.legend.getColumns().setAll((Object[])new TableColumn[]{name, memory, ovhd, size});
        this.legend.setRowFactory(new Callback<TableView<T>, TableRow<T>>(){

            public TableRow<T> call(TableView<T> param) {
                final TableRow tr = new TableRow();
                tr.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent me) {
                        if ((this).ItemPieChart.this.legend.getItems().size() > tr.getIndex()) {
                            MemoryStatisticsItem item = (MemoryStatisticsItem)(this).ItemPieChart.this.legend.getItems().get(tr.getIndex());
                            switch (me.getButton()) {
                                case PRIMARY: {
                                    ItemPieChart.this.onItemPrimaryAction(item);
                                    break;
                                }
                                case SECONDARY: {
                                    ItemPieChart.this.onItemSecondaryAction(item);
                                }
                            }
                        }
                        me.consume();
                    }
                });
                tr.hoverProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> o, Boolean old, Boolean isHovered) {
                        int index = tr.getIndex();
                        if ((this).ItemPieChart.this.legend.getItems().size() > index && index >= 0) {
                            MemoryStatisticsItem item = (MemoryStatisticsItem)(this).ItemPieChart.this.legend.getItems().get(index);
                            ItemPieChart.this.onItemHovered(item, isHovered);
                        }
                    }
                });
                return tr;
            }
        });
        this.legend.getSortOrder().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (ItemPieChart.this.legend.getSortOrder().size() > 0) {
                    TableColumn tc = (TableColumn)ItemPieChart.this.legend.getSortOrder().get(0);
                    if (tc.equals(memory)) {
                        this.setCurrentProperty(PieProperty.MEMORY);
                    } else if (tc.equals(ovhd)) {
                        this.setCurrentProperty(PieProperty.OVERHEAD);
                    } else if (tc.equals(size)) {
                        this.setCurrentProperty(PieProperty.COUNT);
                    }
                }
            }

            private void setCurrentProperty(PieProperty newVal) {
                ItemPieChart.this.currentProperty = newVal;
                ItemPieChart.this.updatePie();
                for (MemoryStatisticsItem item : ItemPieChart.this.pieItems.keySet()) {
                    ((PieChart.Data)ItemPieChart.this.pieItems.get(item)).pieValueProperty().bind(ItemPieChart.this.getProperty(item));
                }
            }
        });
        this.legend.getSortOrder().add((Object)memory);
        this.legend.sort();
    }

    private String getColor(int index) {
        return COLORS[index % COLORS.length];
    }

    protected abstract void onItemPrimaryAction(T var1);

    protected abstract void onItemSecondaryAction(T var1);

    protected abstract void onItemPrimaryAction(Iterable<T> var1);

    protected abstract void onItemSecondaryAction(Iterable<T> var1);

    private static enum PieProperty {
        MEMORY,
        OVERHEAD,
        COUNT;

    }
}

