/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.support.RefChainElement;
import com.oracle.joverflow.ui.model.ModelListener;
import com.oracle.joverflow.ui.model.ObjectCluster;
import com.oracle.joverflow.ui.viewers.ItemPieChart;
import com.oracle.joverflow.ui.viewers.MemoryStatisticsItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class ClusterGroupViewer
implements ModelListener {
    private ItemPieChart<MemoryStatisticsItem> ui;
    private String qualifierName;
    private Runnable updateCallback;
    private Map<Object, MemoryStatisticsItem> items = new HashMap<Object, MemoryStatisticsItem>();
    private Set<Filter> objectClusterFilters = new HashSet<Filter>();

    public ClusterGroupViewer(Runnable updateCallback) {
        this.updateCallback = updateCallback;
        this.ui = new ItemPieChart<MemoryStatisticsItem>("Class"){

            @Override
            public void onItemPrimaryAction(MemoryStatisticsItem item) {
                ClusterGroupViewer.this.addObjectClusterFilter(new StringFilter(false, ClusterGroupViewer.this.qualifierName, item.getId().toString()));
            }

            @Override
            public void onItemSecondaryAction(MemoryStatisticsItem item) {
                ClusterGroupViewer.this.addObjectClusterFilter(new StringFilter(true, ClusterGroupViewer.this.qualifierName, item.getId().toString()));
            }

            @Override
            public void onItemPrimaryAction(Iterable<MemoryStatisticsItem> items) {
                ClusterGroupViewer.this.addObjectClusterFilter(new SetFilter(items, false, ClusterGroupViewer.this.qualifierName));
            }

            @Override
            public void onItemSecondaryAction(Iterable<MemoryStatisticsItem> items) {
                ClusterGroupViewer.this.addObjectClusterFilter(new SetFilter(items, true, ClusterGroupViewer.this.qualifierName));
            }
        };
    }

    public TableView<?> getTable() {
        return this.ui.getLegend();
    }

    public Node getUi() {
        return this.ui;
    }

    public void setQualifierName(String qualifierName) {
        this.qualifierName = qualifierName;
        this.ui.setTitle(qualifierName != null ? qualifierName : "Class");
    }

    public void reset() {
        for (Filter f : this.objectClusterFilters) {
            f.removeFilter();
        }
        this.ui.clear();
    }

    private void addObjectClusterFilter(Filter f) {
        if (this.objectClusterFilters.size() < 8 && this.objectClusterFilters.add(f)) {
            f.setPrefWidth(200.0);
            VBox.setVgrow((Node)f, (Priority)Priority.ALWAYS);
            this.ui.getDetailsPane().getChildren().add((Object)f);
            this.updateCallback.run();
        }
    }

    @Override
    public void include(ObjectCluster oc, RefChainElement ref) {
        String s = this.isGroupingOnQualifier() ? oc.getQualifier() : oc.getClassName();
        MemoryStatisticsItem item = this.items.get(s);
        if (item == null) {
            item = new MemoryStatisticsItem(s, 0L, 0L, 0);
            this.items.put(s, item);
        }
        item.addObjectCluster(oc);
    }

    @Override
    public void allIncluded() {
        this.ui.setContent(this.items.values());
        this.ui.updatePie();
        for (MemoryStatisticsItem i : this.items.values()) {
            i.reset();
        }
    }

    private boolean isGroupingOnQualifier() {
        return this.qualifierName != null;
    }

    public Iterable<? extends Callback<ObjectCluster, Boolean>> getFilters() {
        return this.objectClusterFilters;
    }

    private abstract class Filter
    extends Button
    implements Callback<ObjectCluster, Boolean>,
    EventHandler<ActionEvent> {
        final boolean exclude;
        final String qualifierName;

        Filter(boolean exclude, String qualifierName) {
            this.exclude = exclude;
            this.qualifierName = qualifierName;
            this.setOnAction(this);
        }

        public void handle(ActionEvent event) {
            this.removeFilter();
            ClusterGroupViewer.this.updateCallback.run();
        }

        public void removeFilter() {
            ClusterGroupViewer.this.ui.getDetailsPane().getChildren().remove((Object)this);
            ClusterGroupViewer.this.objectClusterFilters.remove((Object)this);
        }

        public Boolean call(ObjectCluster param) {
            return this.isQualifierFilter() ? (param.getQualifier() == null ? true : this.check(param.getQualifier()) ^ this.exclude) : this.check(param.getClassName()) ^ this.exclude;
        }

        boolean isQualifierFilter() {
            return this.qualifierName != null;
        }

        abstract boolean check(String var1);
    }

    class SetFilter
    extends Filter {
        private Set<String> strings;

        SetFilter(Iterable<MemoryStatisticsItem> item, boolean exclude, String qualifierName) {
            super(exclude, qualifierName);
            this.strings = new HashSet<String>();
            for (MemoryStatisticsItem i : item) {
                this.strings.add(i.getId().toString());
            }
            this.setText(String.valueOf(this.isQualifierFilter() ? qualifierName : "Class") + (exclude ? " \u2209 {" : " \u2208 {") + this.strings.size() + "}");
        }

        @Override
        boolean check(String str) {
            return this.strings.contains(str);
        }
    }

    class StringFilter
    extends Filter {
        private final String string;

        StringFilter(boolean exclude, String qualifierName, String item) {
            super(exclude, qualifierName);
            this.string = item;
            this.setText(String.valueOf(this.isQualifierFilter() ? qualifierName : "Class") + (exclude ? " \u2260 " : " = ") + this.string);
        }

        @Override
        boolean check(String str) {
            return this.string.equals(str);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qualifierName == null ? 0 : this.qualifierName.hashCode());
            result = 31 * result + (this.string == null ? super.hashCode() : this.string.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            StringFilter other = (StringFilter)((Object)obj);
            if (this.qualifierName == null ? other.qualifierName != null : !this.qualifierName.equals(other.qualifierName)) {
                return false;
            }
            if (this.string == null) {
                return false;
            }
            return this.string.equals(other.string);
        }
    }
}

