/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.ui.viewers.ReferrerItem;
import java.text.NumberFormat;
import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.util.Callback;

public class CellFactories {
    private static long totalMemory;
    private static final Callback MEMORY_FORMATTER;
    private static final Callback OVHD_FORMATTER;
    private static final Callback SIZE_FORMATTER;

    static {
        MEMORY_FORMATTER = new NumberCellFactoryImpl(){

            @Override
            Object getValue(ReferrerItem item) {
                return item.getMemory();
            }

            @Override
            String formatOutput(long val) {
                long percent = 100L * val / totalMemory;
                return String.valueOf(CellFactories.asKiloByte(val)) + " (" + percent + "%)";
            }
        };
        OVHD_FORMATTER = new NumberCellFactoryImpl(){

            @Override
            Object getValue(ReferrerItem item) {
                return item.getOvhd();
            }

            @Override
            String formatOutput(long val) {
                long percent = 100L * val / totalMemory;
                return String.valueOf(CellFactories.asKiloByte(val)) + " (" + percent + "%)";
            }
        };
        SIZE_FORMATTER = new NumberCellFactoryImpl(){

            @Override
            Object getValue(ReferrerItem item) {
                return item.getSize();
            }

            @Override
            String formatOutput(long val) {
                return NumberFormat.getInstance().format(val);
            }
        };
    }

    private CellFactories() {
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> getOvhdCellFactory() {
        return OVHD_FORMATTER;
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> getMemoryCellFactory() {
        return MEMORY_FORMATTER;
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> getSizeCellFactory() {
        return SIZE_FORMATTER;
    }

    public static void setTotalMemory(long memory) {
        totalMemory = memory;
    }

    private static String asKiloByte(long value) {
        return NumberFormat.getInstance().format((value + 512L) / 1024L);
    }

    private static abstract class NumberCellFactoryImpl
    implements Callback {
        private NumberCellFactoryImpl() {
        }

        abstract Object getValue(ReferrerItem var1);

        abstract String formatOutput(long var1);

        public Object call(Object arg0) {
            return new TableCell<Object, Object>(){
                {
                    this.setAlignment(Pos.BOTTOM_RIGHT);
                    this.setTooltip(new Tooltip());
                }

                protected void updateItem(Object number, boolean empty) {
                    super.updateItem(number, empty);
                    if (empty) {
                        this.setText(null);
                        this.setTooltip(null);
                    } else {
                        if (number instanceof ReferrerItem) {
                            number = this.getValue((ReferrerItem)number);
                        }
                        if (number instanceof Number) {
                            long val = ((Number)number).longValue();
                            this.setText(this.formatOutput(val));
                            Tooltip tt = this.getTooltip();
                            if (tt == null) {
                                tt = new Tooltip();
                                this.setTooltip(tt);
                            }
                            tt.setText(NumberFormat.getInstance().format(val));
                        } else {
                            this.setText(String.valueOf(number));
                        }
                    }
                }
            };
        }
    }
}

