/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.viewers;

import com.oracle.joverflow.support.RefChainElement;
import com.oracle.joverflow.ui.model.ModelListener;
import com.oracle.joverflow.ui.model.ObjectCluster;
import com.oracle.joverflow.ui.viewers.ItemPieChart;
import com.oracle.joverflow.ui.viewers.MemoryStatisticsItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class AncestorViewer
implements ModelListener {
    private ItemPieChart<MemoryStatisticsItem> ui;
    private TextField text = new TextField();
    private Button updateButton = new Button("Update");
    private Button clearButton = new Button("Clear");
    private Runnable updateCallback;
    private RefChainElement lastRef;
    private MemoryStatisticsItem lastItem;
    private String classNameFilter = "";
    private Map<Object, MemoryStatisticsItem> items = new HashMap<Object, MemoryStatisticsItem>();
    private Set<Filter> filters = new HashSet<Filter>();

    public AncestorViewer(Runnable updateCallback) {
        HBox box = new HBox(5.0);
        this.updateCallback = updateCallback;
        this.clearButton.setMinWidth(60.0);
        this.updateButton.setMinWidth(60.0);
        this.text.setMinHeight(Double.NEGATIVE_INFINITY);
        box.setAlignment(Pos.BOTTOM_RIGHT);
        box.getChildren().addAll((Object[])new Node[]{this.clearButton, this.updateButton});
        this.updateButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AncestorViewer.this.updateFilter();
            }
        });
        this.clearButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AncestorViewer.this.text.setText("");
                AncestorViewer.this.updateFilter();
            }
        });
        this.text.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().isWhitespaceKey()) {
                    AncestorViewer.this.updateFilter();
                }
            }
        });
        this.ui = new ItemPieChart<MemoryStatisticsItem>("Ancestor referrer"){

            @Override
            public void onItemPrimaryAction(MemoryStatisticsItem item) {
                if (item.getId() != null) {
                    AncestorViewer.this.addFilter(new Filter(item.getId().toString(), false));
                }
            }

            @Override
            public void onItemSecondaryAction(MemoryStatisticsItem item) {
                if (item.getId() != null) {
                    AncestorViewer.this.addFilter(new Filter(item.getId().toString(), true));
                }
            }

            @Override
            public void onItemPrimaryAction(Iterable<MemoryStatisticsItem> items) {
            }

            @Override
            public void onItemSecondaryAction(Iterable<MemoryStatisticsItem> items) {
            }
        };
        this.ui.getDetailsPane().getChildren().addAll((Object[])new Node[]{new Label("Ancestor prefix"), this.text, box});
    }

    public TableView<?> getTable() {
        return this.ui.getLegend();
    }

    public void reset() {
        for (Filter f : this.filters) {
            f.removeFilter();
        }
        this.text.setText("");
        this.classNameFilter = "";
        this.ui.clear();
    }

    private void updateFilter() {
        this.classNameFilter = this.text.getText();
        this.ui.clear();
        this.updateCallback.run();
    }

    private void addFilter(Filter f) {
        if (this.filters.size() < 8 && this.filters.add(f)) {
            f.setPrefWidth(200.0);
            VBox.setVgrow((Node)f, (Priority)Priority.ALWAYS);
            this.ui.getDetailsPane().getChildren().add((Object)f);
            this.updateCallback.run();
        }
    }

    public Node getUi() {
        return this.ui;
    }

    @Override
    public void include(ObjectCluster oc, RefChainElement ref) {
        if (ref != this.lastRef) {
            this.lastRef = ref;
            String s = this.getAncestorReferrer(ref);
            this.lastItem = this.items.get(s);
            if (this.lastItem == null) {
                this.lastItem = new MemoryStatisticsItem(s, 0L, 0L, 0);
                this.items.put(s, this.lastItem);
            }
        }
        this.lastItem.addObjectCluster(oc);
    }

    @Override
    public void allIncluded() {
        this.ui.setContent(this.items.values());
        this.ui.updatePie();
        this.lastRef = null;
        for (MemoryStatisticsItem i : this.items.values()) {
            i.reset();
        }
    }

    protected String getAncestorReferrer(RefChainElement referrer) {
        while (referrer != null) {
            if (referrer.getJavaClass() == null) {
                if (referrer.getReferer() == null) break;
                System.err.println("JavaClass for " + referrer + " is null but referrer is " + referrer.getReferer());
                break;
            }
            if (referrer.toString().startsWith(this.classNameFilter)) {
                return referrer.toString();
            }
            referrer = referrer.getReferer();
        }
        return null;
    }

    public Iterable<? extends Callback<RefChainElement, Boolean>> getFilters() {
        return this.filters;
    }

    private class Filter
    extends Button
    implements Callback<RefChainElement, Boolean>,
    EventHandler<ActionEvent> {
        private final String ancestor;
        private final boolean exclude;

        Filter(String ancestor, boolean exclude) {
            this.exclude = exclude;
            this.ancestor = ancestor;
            this.setText("Ancestors" + (exclude ? " \u220c " : " \u220b ") + ancestor);
            this.setOnAction(this);
        }

        public Boolean call(RefChainElement referrer) {
            while (referrer != null) {
                String refName = referrer.toString();
                if (this.ancestor.equals(refName)) {
                    return !this.exclude;
                }
                referrer = referrer.getReferer();
            }
            return this.exclude;
        }

        public void handle(ActionEvent event) {
            this.removeFilter();
            AncestorViewer.this.updateCallback.run();
        }

        void removeFilter() {
            AncestorViewer.this.ui.getDetailsPane().getChildren().remove((Object)this);
            AncestorViewer.this.filters.remove((Object)this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.ancestor == null ? 0 : this.ancestor.hashCode());
            result = 31 * result + (this.exclude ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Filter other = (Filter)((Object)obj);
            if (this.ancestor == null ? other.ancestor != null : !this.ancestor.equals(other.ancestor)) {
                return false;
            }
            return this.exclude == other.exclude;
        }
    }
}

