/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.tabletree;

import com.oracle.joverflow.ui.tabletree.TreeItem;
import java.util.ArrayList;
import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.util.Callback;

public abstract class TreeTable<T extends TreeItem>
extends TableView<T> {
    private static final int LEVEL_INDENT = 8;
    private static final int ICON_SEPARATION = 3;

    protected TreeTable() {
        this.setRowFactory(new Callback<TableView<T>, TableRow<T>>(){

            public TableRow<T> call(TableView<T> param) {
                final TableRow row = new TableRow();
                row.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        TreeTable.this.indexClicked(row.getIndex());
                    }
                });
                return row;
            }
        });
    }

    protected <U> void addTreeColumn(TableColumn<T, U> tc) {
        tc.setCellFactory(new Callback<TableColumn<T, U>, TableCell<T, U>>(){

            public TableCell<T, U> call(TableColumn<T, U> param) {
                return new TableCell<T, U>(){
                    HBox iconPane = new HBox();
                    Node expIcon;
                    Node colIcon;
                    Node parentIcon;
                    Node leafIcon;
                    {
                        this.iconPane.setAlignment(Pos.CENTER_RIGHT);
                        this.expIcon = TreeTable.this.createExpandedIcon();
                        this.colIcon = TreeTable.this.createCollapsedIcon();
                        this.parentIcon = TreeTable.this.createParentIcon();
                        this.leafIcon = TreeTable.this.createLeafIcon();
                    }

                    protected void updateItem(U item, boolean empty) {
                        super.updateItem(item, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            TreeItem i = (TreeItem)TreeTable.this.getItems().get(this.getIndex());
                            this.setText(item.toString());
                            this.iconPane.setMinWidth((double)((i.getLevel() + 1) * 8));
                            if (TreeTable.this.hasChildItems(i)) {
                                Node child = i.isExpanded() ? this.expIcon : this.colIcon;
                                HBox.setMargin((Node)child, (Insets)new Insets(0.0, 0.0, 0.0, (double)(i.getLevel() * 8)));
                                this.iconPane.getChildren().setAll((Object[])new Node[]{child});
                                if (this.parentIcon != null) {
                                    this.iconPane.getChildren().add((Object)this.parentIcon);
                                    HBox.setMargin((Node)this.parentIcon, (Insets)new Insets(0.0, 0.0, 0.0, 3.0));
                                }
                            } else {
                                this.iconPane.getChildren().clear();
                                if (this.leafIcon != null) {
                                    this.iconPane.getChildren().add((Object)this.leafIcon);
                                    HBox.setMargin((Node)this.leafIcon, (Insets)new Insets(0.0, 0.0, 0.0, (double)((i.getLevel() + 1) * 8 + 3)));
                                }
                            }
                            this.setGraphic((Node)this.iconPane);
                        }
                    }
                };
            }
        });
        this.getColumns().add(tc);
        tc.setSortable(false);
    }

    private void indexClicked(int index) {
        if (index >= 0 && index < this.getItems().size()) {
            TreeItem item = (TreeItem)this.getItems().get(index);
            if (item.isExpanded()) {
                int childCount = this.getExpandedChildrenCount(item);
                this.getItems().remove(index + 1, index + childCount + 1);
            } else {
                ArrayList itemList = new ArrayList();
                this.addExpandedChildren(item, itemList);
                this.getItems().addAll(index + 1, itemList);
            }
            item.setExpended(!item.isExpanded());
        }
    }

    private void addExpandedChildren(T item, List<T> itemList) {
        for (TreeItem child : this.getChildItems(item)) {
            itemList.add(child);
            if (!child.isExpanded()) continue;
            this.addExpandedChildren(child, itemList);
        }
    }

    private int getExpandedChildrenCount(T item) {
        int i = 0;
        if (item.isExpanded()) {
            for (TreeItem child : this.getChildItems(item)) {
                ++i;
                i += this.getExpandedChildrenCount(child);
            }
        }
        return i;
    }

    protected Node createExpandedIcon() {
        Polygon p = new Polygon(new double[]{0.0, 4.0, 4.0, 0.0, 4.0, 4.0});
        p.setFill((Paint)Color.color((double)0.0823, (double)0.32, (double)0.8));
        p.setStroke((Paint)Color.BLACK);
        p.getStyleClass().add((Object)"expanded-icon");
        return p;
    }

    protected Node createCollapsedIcon() {
        Polygon p = new Polygon(new double[]{0.0, 0.0, 0.0, 6.0, 4.0, 3.0});
        p.setStroke((Paint)Color.DODGERBLUE);
        p.setFill(null);
        p.getStyleClass().add((Object)"collapsed-icon");
        return p;
    }

    protected Node createParentIcon() {
        return null;
    }

    protected Node createLeafIcon() {
        return null;
    }

    protected abstract boolean hasChildItems(T var1);

    protected abstract Iterable<? extends T> getChildItems(T var1);
}

