/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.model;

import com.oracle.joverflow.ui.model.ClusterType;
import com.oracle.joverflow.ui.model.ObjectCluster;
import java.util.Arrays;

class ObjectClusterImpl
implements ObjectCluster {
    private static final int NONE = -1;
    private int[] indexArray;
    private int lastObj = -1;
    private ClusterType type;
    private int memory;
    private int ovhd;
    private String qualifier;
    private String className;
    private int elementsInArray;

    ObjectClusterImpl(ClusterType type, String className, String qualifier) {
        this.type = type;
        this.className = className;
        this.qualifier = qualifier;
    }

    @Override
    public int getObjectCount() {
        return this.elementsInArray + 1;
    }

    @Override
    public int getMemory() {
        return this.memory;
    }

    @Override
    public int getOverhead() {
        return this.ovhd;
    }

    @Override
    public ClusterType getType() {
        return this.type;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    int addObject(int globalObjectIndex, int memory, int ovhd) {
        if (this.lastObj != globalObjectIndex) {
            if (this.lastObj != -1) {
                this.addtoArray(this.lastObj);
            }
            this.lastObj = globalObjectIndex;
            this.memory += memory;
            this.ovhd += ovhd;
            return memory;
        }
        return 0;
    }

    private void addtoArray(int globalObjectIndex) {
        if (this.indexArray == null) {
            this.indexArray = new int[5];
        } else if (this.elementsInArray == this.indexArray.length) {
            this.indexArray = Arrays.copyOf(this.indexArray, this.indexArray.length + (this.indexArray.length >> 1));
        }
        this.indexArray[this.elementsInArray++] = globalObjectIndex;
    }

    void trim() {
        if (this.indexArray != null) {
            this.indexArray = Arrays.copyOf(this.indexArray, this.elementsInArray);
        }
    }

    @Override
    public int getGlobalObjectIndex(int indexInCluster) {
        if (indexInCluster == this.elementsInArray) {
            return this.lastObj;
        }
        return this.indexArray[indexInCluster];
    }
}

