/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.model;

import com.oracle.joverflow.descriptors.CollectionInstanceDescriptor;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaLazyReadObject;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.heap.model.JavaValueArray;
import com.oracle.joverflow.heap.model.Snapshot;
import com.oracle.joverflow.heap.parser.HeapDumpReader;
import com.oracle.joverflow.heap.parser.HprofParsingCancelledException;
import com.oracle.joverflow.heap.parser.ReadBuffer;
import com.oracle.joverflow.stats.StandardStatsCalculator;
import com.oracle.joverflow.support.Constants;
import com.oracle.joverflow.support.HeapStats;
import com.oracle.joverflow.support.ProblemRecorder;
import com.oracle.joverflow.support.RefChainElement;
import com.oracle.joverflow.ui.model.ClusterType;
import com.oracle.joverflow.ui.model.ModelLoaderListener;
import com.oracle.joverflow.ui.model.ObjectClusterImpl;
import com.oracle.joverflow.ui.model.ReferenceChain;
import com.oracle.joverflow.util.StringInterner;
import com.oracle.joverflow.util.VerboseOutputCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ModelLoader
implements ProblemRecorder,
Runnable {
    private final String fileName;
    private Map<RefChainElement, Map<ClusterType, Map<String, ObjectClusterImpl>>> clusterMap = new IdentityHashMap<RefChainElement, Map<ClusterType, Map<String, ObjectClusterImpl>>>();
    private HeapDumpReader reader;
    private StandardStatsCalculator calculator;
    private ModelLoaderListener loaderListener;

    static {
        Snapshot.Builder.setObjTableSizePolicy((Snapshot.ObjTableSizePolicy)new Snapshot.ObjTableSizePolicy(){

            public int getInitialObjTableSize(long hprofFileSize) {
                return (int)(Math.pow(hprofFileSize, 0.93) / 70.0);
            }
        });
    }

    public ModelLoader(String fileName, ModelLoaderListener loaderListener) {
        this.fileName = fileName;
        this.loaderListener = loaderListener;
    }

    @Override
    public void run() {
        ScheduledExecutorService es = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> progressUpdater = es.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ModelLoader.this.getLoaderListener().onProgressUpdate(ModelLoader.this.getProgress());
                }
                catch (HprofParsingCancelledException hprofParsingCancelledException) {
                    // empty catch block
                }
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        Snapshot snapshot = null;
        try {
            try {
                ReadBuffer.CachedReadBufferFactory factory = new ReadBuffer.CachedReadBufferFactory(this.fileName, ModelLoader.calculateReadbufMemory());
                HeapDumpReader reader = HeapDumpReader.createReader((ReadBuffer.Factory)factory, (int)0, (VerboseOutputCollector)new VerboseOutputCollector());
                this.setReader(reader);
                snapshot = reader.read();
                JavaClass.setFieldBanned((JavaClass)snapshot.getClassForName("java.lang.ref.WeakReference"), (String)"referent");
                StandardStatsCalculator dsc = new StandardStatsCalculator(snapshot, (ProblemRecorder)this, true);
                this.setCalculator(dsc);
                dsc.calculate();
                snapshot.discard();
                snapshot.resetReadBuffer((ReadBuffer.Factory)new ReadBuffer.CachedReadBufferFactory(this.fileName, 0x1900000));
                this.getLoaderListener().onModelLoaded(snapshot, this.buildModel());
            }
            catch (HprofParsingCancelledException e) {
                if (snapshot != null) {
                    snapshot.discard();
                }
                progressUpdater.cancel(true);
                es.shutdown();
            }
            catch (Throwable e) {
                if (snapshot != null) {
                    snapshot.discard();
                }
                try {
                    this.getLoaderListener().onModelLoadFailed(e);
                }
                catch (HprofParsingCancelledException hprofParsingCancelledException) {
                    // empty catch block
                }
                progressUpdater.cancel(true);
                es.shutdown();
            }
        }
        finally {
            progressUpdater.cancel(true);
            es.shutdown();
        }
    }

    public synchronized void cancel() {
        if (this.reader != null) {
            this.reader.cancelReading();
        }
        if (this.calculator != null) {
            this.calculator.cancelCalculation();
        }
        this.loaderListener = null;
    }

    public void initialize(Snapshot snapshot, HeapStats hs) {
    }

    public void recordDuplicateArray(JavaValueArray obj, int ovhd, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.DUPLICATE_ARRAY, cn, obj.valueAsString(true));
        p.addObject(obj.getGlobalObjectIndex(), obj.getSize(), ovhd);
        ObjectClusterImpl np = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        np.addObject(obj.getGlobalObjectIndex(), obj.getSize(), 0);
    }

    public void recordDuplicateString(JavaObject obj, String val, int implInclusiveSize, int ovhd, boolean hasDupCharArray, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.DUPLICATE_STRING, cn, obj.valueAsString());
        p.addObject(obj.getGlobalObjectIndex(), implInclusiveSize, ovhd);
        ObjectClusterImpl np = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        np.addObject(obj.getGlobalObjectIndex(), implInclusiveSize, 0);
    }

    public void recordGoodCollection(JavaLazyReadObject obj, CollectionInstanceDescriptor colDesc, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        p.addObject(obj.getGlobalObjectIndex(), colDesc.getImplSize(), 0);
    }

    public void recordGoodInstance(JavaObject obj, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        p.addObject(obj.getGlobalObjectIndex(), obj.getSize(), 0);
    }

    public void recordNonDuplicateArray(JavaValueArray obj, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        p.addObject(obj.getGlobalObjectIndex(), obj.getSize(), 0);
    }

    public void recordNonDuplicateString(JavaObject obj, int implInclusiveSize, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        p.addObject(obj.getGlobalObjectIndex(), implInclusiveSize, 0);
    }

    public void recordProblematicCollection(JavaLazyReadObject obj, CollectionInstanceDescriptor colDesc, Constants.ProblemKind ovhdKind, int ovhd, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.fromProblemKind(ovhdKind), cn, null);
        p.addObject(obj.getGlobalObjectIndex(), colDesc.getImplSize(), ovhd);
        ObjectClusterImpl np = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        np.addObject(obj.getGlobalObjectIndex(), colDesc.getImplSize(), 0);
    }

    public void recordWeakHashMapWithBackRefs(JavaObject obj, CollectionInstanceDescriptor colDesc, int ovhd, String valueTypeAndFieldSample, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.WEAK_MAP_WITH_BACK_REFS, cn, null);
        p.addObject(obj.getGlobalObjectIndex(), obj.getSize(), ovhd);
        ObjectClusterImpl np = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        np.addObject(obj.getGlobalObjectIndex(), obj.getSize(), 0);
    }

    private Collection<ReferenceChain> buildModel() {
        ArrayList<ReferenceChain> sums = new ArrayList<ReferenceChain>();
        Iterator<Map.Entry<RefChainElement, Map<ClusterType, Map<String, ObjectClusterImpl>>>> clusterIterator = this.clusterMap.entrySet().iterator();
        while (clusterIterator.hasNext()) {
            Map.Entry<RefChainElement, Map<ClusterType, Map<String, ObjectClusterImpl>>> e = clusterIterator.next();
            ReferenceChain summary = new ReferenceChain(e.getKey());
            for (Map<String, ObjectClusterImpl> s : e.getValue().values()) {
                for (ObjectClusterImpl j : s.values()) {
                    j.trim();
                    summary.add(j);
                }
            }
            clusterIterator.remove();
            summary.trim();
            sums.add(summary);
        }
        this.clusterMap = null;
        sums.trimToSize();
        return sums;
    }

    private ObjectClusterImpl getObjectCluster(RefChainElement referrer, ClusterType type, String className, String qualifier) {
        String id;
        ObjectClusterImpl p;
        Map<String, ObjectClusterImpl> m2;
        Map<ClusterType, Map<String, ObjectClusterImpl>> m1 = this.clusterMap.get(referrer);
        if (m1 == null) {
            m1 = new HashMap<ClusterType, Map<String, ObjectClusterImpl>>();
            this.clusterMap.put(referrer, m1);
        }
        if ((m2 = m1.get((Object)type)) == null) {
            m2 = new HashMap<String, ObjectClusterImpl>();
            m1.put(type, m2);
        }
        if ((p = m2.get(id = StringInterner.internString((String)(String.valueOf(className) + "|" + qualifier)))) == null) {
            p = new ObjectClusterImpl(type, className, qualifier == null ? null : qualifier.intern());
            m2.put(id, p);
        }
        return p;
    }

    private synchronized ModelLoaderListener getLoaderListener() throws HprofParsingCancelledException {
        if (this.loaderListener == null) {
            throw new HprofParsingCancelledException();
        }
        return this.loaderListener;
    }

    private synchronized double getProgress() {
        return (this.reader == null ? 0.0 : (double)this.reader.getProgressPercentage() / 200.0) + (this.calculator == null ? 0.0 : (double)this.calculator.getProgressPercentage() / 200.0);
    }

    private synchronized void setCalculator(StandardStatsCalculator dsc) {
        this.calculator = dsc;
    }

    private synchronized void setReader(HeapDumpReader reader) {
        this.reader = reader;
    }

    private static int calculateReadbufMemory() {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        long availableMemory = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        return (int)Math.min(1048576000L, availableMemory / 3L);
    }

    public boolean shouldRecordGoodInstance(JavaObject obj) {
        return true;
    }
}

