/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.model;

import com.oracle.joverflow.support.Constants;

public enum ClusterType {
    EMPTY_USED_COLLECTION("Empty Used Collections"),
    EMPTY_UNUSED_COLLECTION("Empty Unused Collections"),
    EMPTY_ARRAY("Empty Arrays"),
    SPARSE_SMALL_COLLECTION("Sparse Small Collections"),
    SPARSE_LARGE_COLLECTION("Sparse Large Collections"),
    SPARSE_ARRAY("Sparse Arrays"),
    BOXED_COLLECTION("Boxed Collections"),
    ZERO_SIZE_ARRAY("Zero Size Arrays"),
    ONE_ELEMENT_ARRAY("Arrays with One Element"),
    UNUSED_HI_BYTES("Arrays with Underused Elements"),
    WEAK_MAP_WITH_BACK_REFS("Weak Maps with Back References"),
    VERTICAL_BAR_ARRAY("Vertical Bar Arrays"),
    LONG_ZERO_TAIL_ARRAY("Long Zero Tail Arrays"),
    SMALL_COLLECTION("Small Collections"),
    NULL_VALUE("Null Values"),
    DUPLICATE_STRING("Duplicate Strings"),
    DUPLICATE_ARRAY("Duplicate Arrays"),
    ALL_OBJECTS("All Objects");

    private String headline;

    private ClusterType(String headline) {
        this.headline = headline;
    }

    public String getName() {
        return this.headline;
    }

    public static ClusterType fromProblemKind(Constants.ProblemKind pk) {
        switch (pk) {
            case EMPTY_USED: {
                return EMPTY_USED_COLLECTION;
            }
            case EMPTY_UNUSED: {
                return EMPTY_UNUSED_COLLECTION;
            }
            case EMPTY: {
                return EMPTY_ARRAY;
            }
            case SPARSE_SMALL: {
                return SPARSE_SMALL_COLLECTION;
            }
            case SPARSE_LARGE: {
                return SPARSE_LARGE_COLLECTION;
            }
            case SPARSE_ARRAY: {
                return SPARSE_ARRAY;
            }
            case BOXED: {
                return BOXED_COLLECTION;
            }
            case LENGTH_ZERO: {
                return ZERO_SIZE_ARRAY;
            }
            case LENGTH_ONE: {
                return ONE_ELEMENT_ARRAY;
            }
            case UNUSED_HI_BYTES: {
                return UNUSED_HI_BYTES;
            }
            case WEAK_MAP_WITH_BACK_REFS: {
                return WEAK_MAP_WITH_BACK_REFS;
            }
            case BAR: {
                return VERTICAL_BAR_ARRAY;
            }
            case LZT: {
                return LONG_ZERO_TAIL_ARRAY;
            }
            case SMALL: {
                return SMALL_COLLECTION;
            }
        }
        throw new RuntimeException("Unknown problem kind " + pk);
    }

    public String toString() {
        return this.getName();
    }
}

