/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui.fx;

import com.jrockit.mc.ui.misc.HelpSupport;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Scene;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractFxEditor
extends EditorPart {
    private FXCanvas fxCanvas;
    private Form form;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void createPartControl(Composite parent) {
        try {
            FormToolkit ftk = new FormToolkit(parent.getDisplay());
            this.form = ftk.createForm(parent);
            this.form.setText(this.getPartName());
            this.form.setImage(this.getTitleImage());
            ftk.decorateFormHeading(this.form);
            Composite body = this.form.getBody();
            body.setLayout((Layout)new FillLayout());
            this.fxCanvas = new FXCanvas(body, 0);
            this.fxCanvas.setScene(this.createScene());
            this.addToolbarAction(HelpSupport.getHelpAction((String)((Object)((Object)this)).getClass().getName()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Scene createScene() throws Exception;

    public void setFocus() {
        this.fxCanvas.setFocus();
    }

    protected void addToolbarAction(Action action) {
        if (action != null) {
            IToolBarManager manager = this.form.getToolBarManager();
            manager.add((IAction)action);
            this.form.updateToolBar();
        }
    }
}

