/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui;

import java.io.IOException;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

class LoadingUi
extends StackPane {
    private Region veil = new Region();
    private ProgressIndicator p = new ProgressIndicator(0.0);
    private int progressCycle = 0;

    public LoadingUi() throws IOException {
        this.veil.setStyle("-fx-background-color: rgba(0, 0, 0, 0.4)");
        this.p.setMaxSize(150.0, 150.0);
        this.getChildren().addAll((Object[])new Node[]{this.veil, this.p});
    }

    public void setProgress(double progress) {
        if (progress >= 1.0) {
            this.p.setProgress(-1.0);
        } else {
            this.p.setProgress(progress);
        }
        this.progressCycle = (this.progressCycle + 1) % 30;
        double translate = 1.0 + 0.07 * (double)(this.progressCycle - 15) * (double)(this.progressCycle - 15);
        this.p.setTranslateY(translate);
    }

    public void clear() {
        this.veil.setVisible(false);
        this.p.setVisible(false);
    }
}

