/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui;

import com.oracle.joverflow.support.RefChainElement;
import com.oracle.joverflow.ui.fx.FxmlHelper;
import com.oracle.joverflow.ui.model.ClusterType;
import com.oracle.joverflow.ui.model.ModelListener;
import com.oracle.joverflow.ui.model.ObjectCluster;
import com.oracle.joverflow.ui.model.ReferenceChain;
import com.oracle.joverflow.ui.viewers.AncestorViewer;
import com.oracle.joverflow.ui.viewers.CellFactories;
import com.oracle.joverflow.ui.viewers.ClusterGroupViewer;
import com.oracle.joverflow.ui.viewers.OverheadTypeViewer;
import com.oracle.joverflow.ui.viewers.ReferrerViewer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

class JOverflowFxUi
extends VBox {
    @FXML
    private SplitPane leftPane;
    @FXML
    private SplitPane rightPane;
    private List<ModelListener> modelListeners = new ArrayList<ModelListener>();
    private Collection<ReferenceChain> model;
    private AncestorViewer ancestorViewer;
    private OverheadTypeViewer typeViewer;
    private ClusterGroupViewer clusterGroupViewer;
    private ReferrerViewer referrerViewer;
    private Runnable modelUpdater = new Runnable(){

        @Override
        public void run() {
            if (JOverflowFxUi.this.model == null) {
                return;
            }
            ClusterType currentType = JOverflowFxUi.this.typeViewer.getCurrentType();
            JOverflowFxUi.this.clusterGroupViewer.setQualifierName(currentType == ClusterType.DUPLICATE_STRING || currentType == ClusterType.DUPLICATE_ARRAY ? "Duplicate" : null);
            for (ReferenceChain chain : JOverflowFxUi.this.model) {
                RefChainElement rce = chain.getReferenceChain();
                if (!((Boolean)JOverflowFxUi.this.referrerViewer.getFilter().call((Object)rce)).booleanValue() || !JOverflowFxUi.checkFilter(JOverflowFxUi.this.ancestorViewer.getFilters(), rce)) continue;
                for (ObjectCluster oc : chain) {
                    if (!JOverflowFxUi.checkFilter(JOverflowFxUi.this.clusterGroupViewer.getFilters(), oc)) continue;
                    JOverflowFxUi.this.typeViewer.include(oc, rce);
                    if (oc.getType() != currentType) continue;
                    for (ModelListener v : JOverflowFxUi.this.modelListeners) {
                        v.include(oc, chain.getReferenceChain());
                    }
                }
            }
            for (ModelListener v : JOverflowFxUi.this.modelListeners) {
                v.allIncluded();
            }
            JOverflowFxUi.this.typeViewer.allIncluded();
        }
    };

    JOverflowFxUi() throws IOException {
        FxmlHelper.loadFromFxml(((Object)((Object)this)).getClass().getResource("JOverflowFxUi.fxml"), (Object)this, (Object)this);
        this.ancestorViewer = new AncestorViewer(this.modelUpdater);
        this.typeViewer = new OverheadTypeViewer(this.modelUpdater);
        this.clusterGroupViewer = new ClusterGroupViewer(this.modelUpdater);
        this.referrerViewer = new ReferrerViewer(this.modelUpdater);
        this.leftPane.getItems().addAll((Object[])new Node[]{this.typeViewer.getUi(), this.clusterGroupViewer.getUi()});
        this.rightPane.getItems().addAll((Object[])new Node[]{this.referrerViewer.getUi(), this.ancestorViewer.getUi()});
        this.modelListeners.add(this.clusterGroupViewer);
        this.modelListeners.add(this.referrerViewer);
        this.modelListeners.add(this.ancestorViewer);
    }

    public void setModel(Collection<ReferenceChain> model) {
        this.model = model;
        long heapSize = 0L;
        for (ReferenceChain rc : model) {
            for (ObjectCluster oc : rc) {
                if (oc.getType() != ClusterType.ALL_OBJECTS) continue;
                heapSize += (long)oc.getMemory();
            }
        }
        CellFactories.setTotalMemory(heapSize);
        this.modelUpdater.run();
    }

    public void reset() {
        this.ancestorViewer.reset();
        this.typeViewer.reset();
        this.clusterGroupViewer.reset();
        this.referrerViewer.reset();
        this.modelUpdater.run();
    }

    public void addModelListener(final ModelListener collector) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JOverflowFxUi.this.modelListeners.add(collector);
                JOverflowFxUi.this.modelUpdater.run();
            }
        });
    }

    private static <T> boolean checkFilter(Iterable<? extends Callback<T, Boolean>> filters, T obj) {
        for (Callback<T, Boolean> f : filters) {
            if (((Boolean)f.call(obj)).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

