/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui;

import com.jrockit.mc.ui.misc.ErrorDialog;
import com.oracle.joverflow.heap.model.Snapshot;
import com.oracle.joverflow.ui.JOverflowFxUi;
import com.oracle.joverflow.ui.JOverflowPlugin;
import com.oracle.joverflow.ui.LoadingUi;
import com.oracle.joverflow.ui.fx.AbstractStaticFxEditor;
import com.oracle.joverflow.ui.model.ModelLoader;
import com.oracle.joverflow.ui.model.ModelLoaderListener;
import com.oracle.joverflow.ui.model.ReferenceChain;
import java.util.Collection;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;

public class JOverflowEditor
extends AbstractStaticFxEditor {
    private JOverflowFxUi ui;
    private ModelLoader loader;
    public static final String EDITOR_ID = "com.oracle.joverflow.ui.JOverflowEditor";
    private Snapshot snapshot;

    @Override
    protected Scene createScene() throws Exception {
        IEditorInput input = this.getEditorInput();
        IPathEditorInput ipei = input instanceof IPathEditorInput ? (IPathEditorInput)input : (IPathEditorInput)input.getAdapter(IPathEditorInput.class);
        final LoadingUi loderUi = new LoadingUi();
        this.ui = new JOverflowFxUi();
        loderUi.getChildren().add(0, (Object)this.ui);
        if (ipei == null) {
            throw new Exception("The JOverflow editor cannot handle the provided editor input");
        }
        final String fileName = ipei.getPath().toOSString();
        this.loader = new ModelLoader(fileName, new ModelLoaderListener(){

            @Override
            public void onProgressUpdate(final double progress) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        loderUi.setProgress(progress);
                    }
                });
            }

            @Override
            public void onModelLoaded(Snapshot snapshot, final Collection<ReferenceChain> model) {
                JOverflowEditor.this.setModelLoaded(snapshot);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JOverflowEditor.this.ui.setModel(model);
                        loderUi.clear();
                    }
                });
            }

            @Override
            public void onModelLoadFailed(final Throwable failure) {
                JOverflowEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String message = failure.getLocalizedMessage();
                        ErrorDialog.showException((Shell)JOverflowEditor.this.getSite().getShell(), (String)("Could not open " + fileName), (String)message, (Throwable)failure);
                        JOverflowEditor.this.getSite().getPage().closeEditor((IEditorPart)JOverflowEditor.this, false);
                    }
                });
                JOverflowEditor.this.cancelAndClearLoader();
            }
        });
        loderUi.getStylesheets().add((Object)JOverflowFxUi.class.getResource("grey_round_tables.css").toExternalForm());
        Executors.newSingleThreadExecutor().submit(this.loader);
        this.addToolbarAction(new Action("Reset"){
            {
                this.setImageDescriptor(JOverflowPlugin.getDefault().getMCImageDescriptor("undo_edit.gif"));
            }

            public void run() {
                JOverflowEditor.this.ui.reset();
            }
        });
        return new Scene((Parent)loderUi);
    }

    public void dispose() {
        super.dispose();
        this.cancelAndClearLoader();
        if (this.snapshot != null) {
            this.snapshot.discard();
        }
    }

    private synchronized void cancelAndClearLoader() {
        if (this.loader != null) {
            this.loader.cancel();
            this.loader = null;
        }
    }

    private synchronized void setModelLoaded(Snapshot snapshot) {
        if (this.loader == null) {
            snapshot.discard();
        } else {
            this.snapshot = snapshot;
            this.loader = null;
        }
    }

    JOverflowFxUi getJOverflowFxUi() {
        return this.ui;
    }

    Snapshot getSnapshot() {
        return this.snapshot;
    }
}

