/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.ui;

import com.oracle.joverflow.heap.model.JavaHeapObject;
import com.oracle.joverflow.heap.model.Snapshot;
import com.oracle.joverflow.ui.JOverflowFxUi;
import com.oracle.joverflow.ui.LoadingUi;
import com.oracle.joverflow.ui.model.ModelLoader;
import com.oracle.joverflow.ui.model.ModelLoaderListener;
import com.oracle.joverflow.ui.model.ReferenceChain;
import com.oracle.joverflow.ui.viewers.JavaThingViewer;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.Executors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class FxMain
extends Application {
    public void start(Stage primaryStage) throws Exception {
        File f;
        if (this.getParameters().getUnnamed().size() != 1) {
            System.out.println("Please specify hprof file argument");
            System.exit(1);
        }
        if (!(f = new File((String)this.getParameters().getUnnamed().get(0))).isFile()) {
            System.out.println(f + " does not exist");
            System.exit(2);
        }
        final LoadingUi loderUi = new LoadingUi();
        final JOverflowFxUi ui = new JOverflowFxUi();
        loderUi.getChildren().add(0, (Object)ui);
        loderUi.getStylesheets().add((Object)JOverflowFxUi.class.getResource("grey_round_tables.css").toExternalForm());
        ModelLoader loader = new ModelLoader(f.getAbsolutePath(), new ModelLoaderListener(){

            @Override
            public void onProgressUpdate(final double progress) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        loderUi.setProgress(progress);
                    }
                });
            }

            @Override
            public void onModelLoaded(final Snapshot snapshot, final Collection<ReferenceChain> model) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JavaThingViewer javaThingViewer = new JavaThingViewer(){

                            @Override
                            protected JavaHeapObject getObjectAtPostion(int globalObjectPos) {
                                return snapshot.getObjectAtGlobalIndex(globalObjectPos);
                            }
                        };
                        javaThingViewer.getUi().getStylesheets().add((Object)this.getClass().getResource("grey.css").toExternalForm());
                        ui.addModelListener(javaThingViewer);
                        Stage instanceStage = new Stage();
                        instanceStage.setScene(new Scene(javaThingViewer.getUi()));
                        instanceStage.centerOnScreen();
                        instanceStage.show();
                        loderUi.clear();
                        ui.setModel(model);
                    }
                });
            }

            @Override
            public void onModelLoadFailed(Throwable failure) {
                failure.printStackTrace();
                System.err.println(failure);
                System.exit(-1);
            }
        });
        Scene scene = new Scene((Parent)loderUi);
        primaryStage.setScene(scene);
        primaryStage.show();
        Executors.newSingleThreadExecutor().submit(loader);
    }

    public static void main(String[] args) {
        FxMain.launch((String[])args);
    }
}

