/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

import com.jrockit.mc.dtrace.events.code.EventTypeDescriptor;
import com.jrockit.mc.dtrace.events.code.FieldDescriptor;
import com.jrockit.mc.dtrace.events.code.IProgress;
import com.jrockit.mc.dtrace.events.code.ProducerDescriptor;
import com.jrockit.mc.dtrace.language.dEL.CodeFragment;
import com.jrockit.mc.dtrace.language.dEL.EventCommandType;
import com.jrockit.mc.dtrace.language.dEL.EventDeclaration;
import com.jrockit.mc.dtrace.language.dEL.EventStatement;
import com.jrockit.mc.dtrace.language.dEL.ProbeDeclaration;
import com.jrockit.mc.dtrace.language.dEL.Program;
import com.jrockit.mc.dtrace.language.dEL.Property;
import com.jrockit.mc.dtrace.language.dEL.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

class Verification {
    private final IProgress m_progress;
    private final List<EventStatement> m_beginStatements;
    private final List<EventStatement> m_endStatements;
    private final List<EventStatement> m_emitStatements;
    private final List<EventStatement> m_allStatements = new ArrayList<EventStatement>();
    private final ProducerDescriptor m_producer;
    private boolean m_error;

    public Verification(IProgress progress, Program program, ProducerDescriptor producerDescriptor) {
        this.m_producer = producerDescriptor;
        this.m_progress = progress;
        this.m_beginStatements = this.collectEventStatements(program, EventCommandType.BEGIN);
        this.m_endStatements = this.collectEventStatements(program, EventCommandType.END);
        this.m_emitStatements = this.collectEventStatements(program, EventCommandType.EMIT);
        this.m_allStatements.addAll(this.m_beginStatements);
        this.m_allStatements.addAll(this.m_endStatements);
        this.m_allStatements.addAll(this.m_emitStatements);
    }

    void verifyEventStatmentsNotBroken() {
        for (EventStatement es : this.m_allStatements) {
            EventDeclaration ed = es.getName();
            if (ed == null || ed.getName() == null) {
                this.addError("Missing event identifier.", (EObject)es);
                continue;
            }
            String eventId = ed.getName();
            EList arguments = es.getListOfArgs();
            if (arguments == null) {
                this.addError("Missing arguments for event " + eventId, (EObject)es);
                continue;
            }
            for (Property p : arguments) {
                if (p.getKey() == null) {
                    this.addError("Missing field identifier for event " + eventId, (EObject)es);
                }
                if (p.getValue() != null) continue;
                this.addError("Missing value for " + p.getKey() + " in event " + eventId, (EObject)es);
            }
        }
    }

    void verfiryEventStatementsMatchEventTypes() {
        for (EventStatement es : this.m_allStatements) {
            String eventId = es.getName().getName();
            EventTypeDescriptor etd = this.getDescriptorByIdentfier(eventId);
            if (etd == null) {
                this.addError("Unknown event id " + eventId + " in " + es.getCommand().getName().toLowerCase() + " statement", (EObject)es);
                continue;
            }
            for (Property p : es.getListOfArgs()) {
                FieldDescriptor f = etd.getField(p.getKey());
                if (f != null) continue;
                this.addError("Statement " + es.getCommand().getName().toLowerCase() + " refer to the field " + p.getKey() + " which does not exist in event " + eventId, (EObject)es);
            }
        }
    }

    public void verifyEmitStatmentNotUSedWithBeginAndEnd() {
        for (EventStatement es : this.m_emitStatements) {
            for (EventStatement b : this.m_beginStatements) {
                if (es.getName() != b.getName()) continue;
                this.addError("Emit statement for " + es.getName().getName() + " can not be used together with begin statement.", (EObject)b);
            }
            for (EventStatement e : this.m_endStatements) {
                if (es.getName() != e.getName()) continue;
                this.addError("Emit statement for " + es.getName().getName() + " can not be used together with begin statement.", (EObject)e);
            }
        }
    }

    public void verifyBeginAndEndUsesAllFields() {
        for (EventStatement beginStatement : this.m_beginStatements) {
            HashSet<String> identifiers = new HashSet<String>();
            EventTypeDescriptor etd = this.getDescriptorByIdentfier(beginStatement.getName().getName());
            for (FieldDescriptor f : etd.getFields()) {
                identifiers.add(f.getIdentifier());
            }
            for (Property p : beginStatement.getListOfArgs()) {
                identifiers.remove(p.getKey());
            }
            for (EventStatement endStatement : this.m_endStatements) {
                if (endStatement.getName() != beginStatement.getName()) continue;
                HashSet remainingIds = new HashSet(identifiers);
                for (Property p : endStatement.getListOfArgs()) {
                    identifiers.remove(p.getKey());
                }
                for (String id : remainingIds) {
                    this.addError("No value for the field " + id + " in begin or end statement for the event " + etd.getIdentifier(), (EObject)endStatement);
                }
            }
        }
    }

    List<EventStatement> collectEventStatements(Program program, EventCommandType type) {
        ArrayList<EventStatement> ess = new ArrayList<EventStatement>();
        for (CodeFragment cf : program.getCodeFragments()) {
            if (!(cf instanceof ProbeDeclaration)) continue;
            ProbeDeclaration probeDeclaration = (ProbeDeclaration)cf;
            for (Statement statement : probeDeclaration.getStatements()) {
                EventStatement es;
                EList statements = probeDeclaration.getStatements();
                if (statements == null) {
                    this.addError("Broken statements in probe.", (EObject)probeDeclaration);
                }
                if (!(statement instanceof EventStatement) || (es = (EventStatement)statement).getCommand() != type) continue;
                ess.add(es);
            }
        }
        return ess;
    }

    private EventTypeDescriptor getDescriptorByIdentfier(String identifier) {
        return this.m_producer.lookupEventType(identifier);
    }

    void addError(String message, EObject e) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)e);
        if (node != null) {
            this.m_progress.addError(message, node.getEndLine());
        } else {
            this.m_progress.addError(message);
        }
        this.m_error = true;
    }

    void addError(String message) {
        this.m_progress.addError(message);
        this.m_error = true;
    }

    void clearErrors() {
        this.m_error = false;
    }

    boolean hasError() {
        return this.m_error;
    }

    public void verifyBeginStatementOnlyReferenceFieldOnce() {
        this.verifyStatementOnlyReferenceFieldOnce(this.m_beginStatements, "begin");
    }

    public void verifyEndStatementOnlyReferenceFieldOnce() {
        this.verifyStatementOnlyReferenceFieldOnce(this.m_endStatements, "end");
    }

    public void verifyEmitStatementOnlyReferenceFieldOnce() {
        this.verifyStatementOnlyReferenceFieldOnce(this.m_emitStatements, "emit");
    }

    private void verifyStatementOnlyReferenceFieldOnce(List<EventStatement> statements, String statementType) {
        for (EventStatement s : statements) {
            HashSet<String> used = new HashSet<String>();
            for (Property p : s.getListOfArgs()) {
                if (!used.contains(p.getKey())) {
                    used.add(p.getKey());
                    continue;
                }
                this.addError("Field " + p.getKey() + " already used in " + statementType + " statement.", (EObject)p);
            }
        }
    }

    public void verifyBeginStamentsUseSameArguments() {
        this.verifyStamentsUseSameArguments(this.m_beginStatements);
    }

    public void verifyEndStamentsUseSameArguments() {
        this.verifyStamentsUseSameArguments(this.m_endStatements);
    }

    public void verifyEmitStatmentsComplete() {
        this.verifyStamentsUseSameArguments(this.m_emitStatements);
    }

    private void verifyStamentsUseSameArguments(List<EventStatement> statements) {
        HashMap fieldSetLookup = new HashMap();
        for (EventStatement b : statements) {
            HashSet<String> fieldSet = (HashSet<String>)fieldSetLookup.get(b.getName().getName());
            if (fieldSet == null) {
                fieldSet = new HashSet<String>();
                for (Property p : b.getListOfArgs()) {
                    fieldSet.add(p.getKey());
                }
                fieldSetLookup.put(b.getName().getName(), fieldSet);
                continue;
            }
            for (Property p : b.getListOfArgs()) {
                if (fieldSet.contains(p.getKey())) continue;
                this.addError("All " + b.getCommand().getName().toLowerCase() + " statements for the event " + b.getName().getName() + " must reference the same fields.", (EObject)b);
            }
        }
    }
}

