/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

import com.jrockit.mc.dtrace.language.dEL.BooleanValue;
import com.jrockit.mc.dtrace.language.dEL.DoubleValue;
import com.jrockit.mc.dtrace.language.dEL.IdentifierValue;
import com.jrockit.mc.dtrace.language.dEL.IntegerValue;
import com.jrockit.mc.dtrace.language.dEL.ParameterDeclaration;
import com.jrockit.mc.dtrace.language.dEL.ProbeDeclaration;
import com.jrockit.mc.dtrace.language.dEL.ProbeSetDeclaration;
import com.jrockit.mc.dtrace.language.dEL.Property;
import com.jrockit.mc.dtrace.language.dEL.StringValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class Toolkit {
    public static <T> List<T> getAllChildrenDFS(EObject e, Class<T> clazz) {
        LinkedList<EObject> q = new LinkedList<EObject>();
        q.add(e);
        HashSet<EObject> visited = new HashSet<EObject>();
        ArrayList<EObject> instances = new ArrayList<EObject>();
        while (!q.isEmpty()) {
            EObject object = (EObject)q.poll();
            if (object == null) continue;
            if (!visited.contains(object)) {
                if (clazz.isAssignableFrom(object.getClass())) {
                    EObject t = object;
                    instances.add(t);
                }
                for (EObject child : object.eContents()) {
                    q.add(child);
                }
                for (EObject child : object.eCrossReferences()) {
                    q.add(child);
                }
            }
            visited.add(object);
        }
        return instances;
    }

    public static String getProbeName(ProbeDeclaration p) {
        String name = p.getName();
        if (p.getLabel() != null) {
            name = p.getLabel().getValue();
        }
        return name;
    }

    public static String getType(ParameterDeclaration p) {
        String type = "text";
        if (p.getType() != null) {
            type = p.getType().getValue();
        }
        return type;
    }

    public static String getProbeSetName(ProbeSetDeclaration p) {
        String name = p.getName();
        if (p.getLabel() != null) {
            name = p.getLabel().getValue();
        }
        return name;
    }

    public static Object getPropertyValue(EList<Property> properties, String key) {
        for (Property p : properties) {
            Object o = Toolkit.getPropertyValue(p);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public static Object getPropertyValue(Property p) {
        if (p.getValue() instanceof IntegerValue) {
            IntegerValue iv = (IntegerValue)p.getValue();
            return new Integer(iv.getContents());
        }
        if (p.getValue() instanceof DoubleValue) {
            DoubleValue iv = (DoubleValue)p.getValue();
            return new Double(iv.getContents());
        }
        if (p.getValue() instanceof StringValue) {
            StringValue iv = (StringValue)p.getValue();
            return iv.getContents();
        }
        if (p.getValue() instanceof IdentifierValue) {
            IdentifierValue iv = (IdentifierValue)p.getValue();
            return iv.getContents();
        }
        if (p.getValue() instanceof BooleanValue) {
            BooleanValue iv = (BooleanValue)p.getValue();
            return iv.getContents();
        }
        throw new RuntimeException("Unknown type");
    }
}

