/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

final class TimeLimitedScriptBuilder {
    private StringBuffer m_buffer = new StringBuffer();
    private final int m_seconds;
    private final String m_script;

    TimeLimitedScriptBuilder(String script, int seconds) {
        this.m_script = script;
        this.m_seconds = seconds;
    }

    public String build() {
        this.clear();
        this.writeBeginProbe(this.m_seconds);
        this.writeCountDownProbe();
        this.writeExitProbe();
        this.writeEndProbe(this.m_seconds);
        this.writeScript();
        return this.getOutput();
    }

    private void writeEndProbe(int m_seconds2) {
        this.writeLine("dtrace:::END");
        this.writeLine("{");
        this.writeLine("   printf(\"timestamp Recording... %d \",  1000*1000*1000*(this->count) );");
        this.writeLine("}");
        this.writeLine("");
    }

    private void clear() {
        this.m_buffer = new StringBuffer();
    }

    private void writeBeginProbe(int seconds) {
        this.writeLine("dtrace:::BEGIN");
        this.writeLine("{");
        this.writeLine("  timeout = " + seconds + ";");
        this.writeLine("  printf(\"timestamp Recording... " + System.currentTimeMillis() + ' ' + (long)seconds * 1000000000L + "\");");
        this.writeLine("}");
        this.writeLine("");
    }

    private void writeCountDownProbe() {
        this.writeLine("profile:::tick-1s");
        this.writeLine("/ timeout != 0 /");
        this.writeLine("{");
        this.writeLine("   this->count++;");
        this.writeLine("}");
        this.writeLine("");
    }

    private void writeExitProbe() {
        this.writeLine("profile:::tick-1s");
        this.writeLine("/  timeout != 0 && this->count >= timeout /");
        this.writeLine("{");
        this.writeLine("   exit(0);");
        this.writeLine("}");
        this.writeLine("");
    }

    private void writeLine(String line) {
        this.m_buffer.append(line);
        this.m_buffer.append(System.getProperty("line.separator"));
    }

    private String getOutput() {
        return this.m_buffer.toString();
    }

    private void writeScript() {
        this.m_buffer.append(this.m_script);
    }
}

