/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.dtrace.events.code.Parameter;
import com.jrockit.mc.dtrace.events.code.Probe;
import com.jrockit.mc.dtrace.events.code.ProbeSet;
import java.util.List;

public final class TemplateDescriptor {
    private static final String RECORDING_TIME = "recordingTime";
    private static final String HIDDEN = "hidden";
    private static final String DEFAULT = "default";
    private static final String IDENTIFIER = "identifier";
    private static final String NAME = "name";
    private static final String PARAMETERS = "parameters";
    private static final String PROBESETS = "probeSets";
    private static final String SELECTED = "selected";
    private static final String PROBES = "probes";
    private static final String BUFFER_POLICY = "bufferPolicy";
    private final Setting m_setting = new Setting("templateDescriptor");

    static {
        PersistenceToolkit.registerFetcher(TemplateDescriptor.class, (ISettingFetcher)new ISettingFetcher<TemplateDescriptor>(){

            public Setting getSetting(TemplateDescriptor c) {
                return c.m_setting;
            }
        });
    }

    public TemplateDescriptor() {
        this.setHidden(false);
        this.m_setting.setChildObject(RECORDING_TIME, (Object)this.createRecordingTime());
        this.m_setting.setChildObject(BUFFER_POLICY, this.createBufferPolicy());
    }

    private Object createBufferPolicy() {
        Parameter param = new Parameter();
        param.setName("Buffer Policy");
        param.setidentifier(BUFFER_POLICY);
        param.setType(BUFFER_POLICY);
        param.setLastValue("switch");
        return param;
    }

    private Parameter createRecordingTime() {
        Parameter param = new Parameter();
        param.setName("Recording Time:");
        param.setidentifier(RECORDING_TIME);
        param.setType(UnitLookup.TIMESPAN.getIdentifier());
        param.setProperty("min", "1000000000");
        param.setProperty("max", "1000000000000000");
        param.setName("Recording Time:");
        param.setLastValue("50000000000");
        return param;
    }

    public Parameter getRecordingTime() {
        return (Parameter)this.m_setting.getChildObject(RECORDING_TIME, Parameter.class);
    }

    public boolean isDefault() {
        return (Boolean)this.m_setting.getChildObject(DEFAULT, Boolean.class);
    }

    public void setHidden(boolean hidden) {
        this.m_setting.setChildObject(HIDDEN, (Object)hidden);
    }

    public String getidentifier() {
        return (String)this.m_setting.getChildObject(IDENTIFIER, String.class);
    }

    public String getName() {
        return (String)this.m_setting.getChildObject(NAME, String.class);
    }

    public void setIdentifier(String name) {
        this.m_setting.setChildObject(IDENTIFIER, (Object)name);
    }

    public void setName(String templateName) {
        this.m_setting.setChildObject(NAME, (Object)templateName);
    }

    public List<Parameter> getParameters() {
        return (List)this.m_setting.getChildObject(PARAMETERS, new Type(List.class, new Type[]{new Type(Parameter.class)}));
    }

    public List<ProbeSet> getProbeSets() {
        return (List)this.m_setting.getChildObject(PROBESETS, new Type(List.class, new Type[]{new Type(ProbeSet.class)}));
    }

    public boolean isSelected() {
        return (Boolean)this.m_setting.getChildObject(SELECTED, Boolean.class);
    }

    public List<Probe> getProbes() {
        return (List)this.m_setting.getChildObject(PROBES, new Type(List.class, new Type[]{new Type(Probe.class)}));
    }

    public void setSelected(boolean selected) {
        this.m_setting.setChildObject(SELECTED, (Object)selected);
    }

    public Parameter getBufferPolicy() {
        return (Parameter)this.m_setting.getChildObject(BUFFER_POLICY, Parameter.class);
    }
}

