/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.dtrace.events.code.IProgress;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public final class SourceLoader {
    private static final String LINE_BREAK = "\n";
    private final File m_file;

    public SourceLoader(File file) {
        this.m_file = file;
    }

    String loadSource(IProgress progress) {
        progress.beginTask("Loading source code.");
        if (!this.m_file.getName().endsWith(".de")) {
            progress.addError("DTrace event file must end with .de");
        }
        String result = null;
        if (!this.m_file.exists()) {
            progress.addError("Can't find file named " + this.m_file);
        }
        try {
            result = this.readSource(progress);
        }
        catch (IOException e) {
            progress.addError("Error reading file: " + e.getMessage());
        }
        progress.endTask();
        return result;
    }

    private String readSource(IProgress progress) throws IOException {
        StringBuffer sb = new StringBuffer();
        FileReader fr = new FileReader(this.m_file);
        BufferedReader br = new BufferedReader(fr);
        int lineCount = 0;
        try {
            String line = br.readLine();
            while (line != null) {
                if (lineCount % 100 == 0) {
                    progress.doWork();
                }
                sb.append(line);
                sb.append(LINE_BREAK);
                line = br.readLine();
                ++lineCount;
            }
        }
        finally {
            IOToolkit.closeSilently((Closeable)br);
        }
        return sb.toString();
    }
}

