/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

import com.jrockit.mc.dtrace.events.code.IProgress;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SimpleProgress
implements IProgress {
    private final PrintWriter m_out;
    private final List<String> m_errors = Collections.synchronizedList(new ArrayList());

    SimpleProgress(PrintWriter out) {
        this.m_out = out;
    }

    public SimpleProgress() {
        this(new PrintWriter(System.out));
    }

    @Override
    public void beginTask(String name) {
        if (this.m_out != null) {
            this.m_out.print(String.valueOf(name) + "...");
        }
    }

    @Override
    public void doWork() {
        if (this.m_out != null) {
            this.m_out.print(".");
        }
    }

    @Override
    public void endTask() {
        if (this.m_out != null) {
            this.m_out.print(" finished!");
        }
    }

    @Override
    public void addError(String s, int line) {
        if (this.m_out != null) {
            this.m_errors.add(String.valueOf(s) + " line " + line);
        }
    }

    @Override
    public void addError(String s) {
        if (this.m_out != null) {
            this.m_errors.add(s);
        }
    }

    @Override
    public boolean hasErrors() {
        return !this.m_errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.m_errors;
    }
}

