/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.dtrace.events.code.DTraceCode;
import com.jrockit.mc.dtrace.events.code.Metadata;
import com.jrockit.mc.dtrace.events.code.TemplateDescriptor;
import java.util.List;

public final class ScriptModel {
    private static final String METADATA = "metadata";
    private static final String DTRACE_CODE = "dtraceCode";
    private static final String SOURCE_CODE = "sourceCode";
    private static final String SCRIPT = "script";
    private static final String TEMPLATES = "templates";
    private final Setting m_setting = new Setting("script");

    static {
        PersistenceToolkit.registerFetcher(ScriptModel.class, (ISettingFetcher)new ISettingFetcher<ScriptModel>(){

            public Setting getSetting(ScriptModel c) {
                return c.m_setting;
            }
        });
    }

    public Metadata getMetadata() {
        return (Metadata)this.m_setting.getChildObject(METADATA, Metadata.class);
    }

    public String getSourceCode() {
        return (String)this.m_setting.getChildObject(SOURCE_CODE, String.class);
    }

    public List<TemplateDescriptor> getTemplates() {
        return (List)this.m_setting.getChildObject(TEMPLATES, new Type(List.class, new Type[]{new Type(TemplateDescriptor.class)}));
    }

    public TemplateDescriptor findTemplates(String identifier) {
        for (TemplateDescriptor td : this.getTemplates()) {
            if (!identifier.equals(td.getidentifier())) continue;
            return td;
        }
        return null;
    }

    public List<DTraceCode> getDTraceCode() {
        return (List)this.m_setting.getChildObject(DTRACE_CODE, new Type(List.class, new Type[]{new Type(DTraceCode.class)}));
    }

    public void setSourceCode(String sourceCode) {
        this.m_setting.setChildObject(SOURCE_CODE, (Object)sourceCode);
    }

    public TemplateDescriptor getSelectedTemplate() {
        for (TemplateDescriptor td : this.getTemplates()) {
            if (!td.isSelected()) continue;
            return td;
        }
        return null;
    }
}

