/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

import com.jrockit.mc.dtrace.events.code.BeginEndAnnotater;
import com.jrockit.mc.dtrace.events.code.Compiler;
import com.jrockit.mc.dtrace.events.code.DTraceCode;
import com.jrockit.mc.dtrace.events.code.EventTypeDescriptor;
import com.jrockit.mc.dtrace.events.code.FieldDescriptor;
import com.jrockit.mc.dtrace.events.code.IProgress;
import com.jrockit.mc.dtrace.events.code.Metadata;
import com.jrockit.mc.dtrace.events.code.MetadataBuilder;
import com.jrockit.mc.dtrace.events.code.Parameter;
import com.jrockit.mc.dtrace.events.code.Probe;
import com.jrockit.mc.dtrace.events.code.ProbeSet;
import com.jrockit.mc.dtrace.events.code.ProducerDescriptor;
import com.jrockit.mc.dtrace.events.code.ScriptModel;
import com.jrockit.mc.dtrace.events.code.SemanticVerifier;
import com.jrockit.mc.dtrace.events.code.TemplateDescriptor;
import com.jrockit.mc.dtrace.events.code.Toolkit;
import com.jrockit.mc.dtrace.events.code.Variable;
import com.jrockit.mc.dtrace.language.dEL.CodeFragment;
import com.jrockit.mc.dtrace.language.dEL.DTraceStatement;
import com.jrockit.mc.dtrace.language.dEL.EventCommandType;
import com.jrockit.mc.dtrace.language.dEL.EventStatement;
import com.jrockit.mc.dtrace.language.dEL.ParameterAssignment;
import com.jrockit.mc.dtrace.language.dEL.ParameterDeclaration;
import com.jrockit.mc.dtrace.language.dEL.ProbeAssignment;
import com.jrockit.mc.dtrace.language.dEL.ProbeDeclaration;
import com.jrockit.mc.dtrace.language.dEL.ProbeSetAssignment;
import com.jrockit.mc.dtrace.language.dEL.ProbeSetDeclaration;
import com.jrockit.mc.dtrace.language.dEL.Program;
import com.jrockit.mc.dtrace.language.dEL.Property;
import com.jrockit.mc.dtrace.language.dEL.Statement;
import com.jrockit.mc.dtrace.language.dEL.TemplateDeclaration;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public final class ScriptFactory {
    private final String m_sourceCode;
    private final Map<CodeFragment, Integer> sequenceMap = new HashMap<CodeFragment, Integer>();
    private ProducerDescriptor m_producerDescriptor;

    public ScriptFactory(String sourceCode) {
        this.m_sourceCode = sourceCode;
    }

    public ScriptModel createScriptModel(IProgress progress) {
        ScriptModel script = new ScriptModel();
        Compiler cl = new Compiler();
        Program p = cl.compile(progress, this.m_sourceCode);
        if (p != null) {
            MetadataBuilder etf = new MetadataBuilder();
            Metadata metadata = script.getMetadata();
            etf.createMetadata(p, metadata, progress);
            if (!metadata.getProducers().isEmpty()) {
                this.m_producerDescriptor = metadata.getProducers().get(0);
                SemanticVerifier v = new SemanticVerifier(this.m_producerDescriptor);
                if (v.verify(p, progress)) {
                    BeginEndAnnotater b = new BeginEndAnnotater(metadata, p);
                    b.annotate();
                    return this.buildScriptModel(progress, script, p);
                }
            }
        }
        return null;
    }

    ScriptModel buildScriptModel(IProgress progress, ScriptModel script, Program program) {
        script.setSourceCode(this.m_sourceCode);
        int index = 0;
        for (CodeFragment cf : program.getCodeFragments()) {
            if (cf instanceof DTraceStatement) {
                DTraceStatement dc = (DTraceStatement)cf;
                String code = this.objectToCode((EObject)dc);
                DTraceCode dt = new DTraceCode();
                if (code != null) {
                    dt.setCode(code);
                }
                dt.setSequenceNumber(index);
                script.getDTraceCode().add(dt);
                this.sequenceMap.put(cf, index);
            }
            if (cf instanceof ProbeDeclaration) {
                this.sequenceMap.put(cf, index);
            }
            ++index;
        }
        for (TemplateDeclaration t : Toolkit.getAllChildrenDFS((EObject)program, TemplateDeclaration.class)) {
            try {
                TemplateDescriptor td = this.createTemplate(t, script);
                if (td == null) continue;
                script.getTemplates().add(td);
            }
            catch (ParseException e) {
                progress.addError("Could not process template: " + e.getMessage());
            }
        }
        return script;
    }

    private TemplateDescriptor createTemplate(TemplateDeclaration t, ScriptModel script) throws ParseException {
        TemplateDescriptor newT = new TemplateDescriptor();
        newT.setName(ScriptFactory.getTemplateName(t));
        newT.setIdentifier(t.getName());
        this.addParameters(t, newT);
        this.addProbeSet(t, newT, script);
        return newT;
    }

    public static String getTemplateName(TemplateDeclaration td) {
        String name = td.getName();
        if (td.getLabel() != null) {
            name = td.getLabel().getValue();
        }
        return name;
    }

    private void addParameters(TemplateDeclaration t, TemplateDescriptor td) {
        for (ParameterAssignment pa : t.getParameterAssignments()) {
            Parameter p = this.createParameter(pa);
            if (p == null) continue;
            td.getParameters().add(p);
        }
    }

    private Parameter createParameter(ParameterAssignment pa) {
        ParameterDeclaration p = pa.getParameter();
        if (p != null && p.getName() != null) {
            Parameter param = new Parameter();
            param.setName(ScriptFactory.getParameterName(p));
            param.setidentifier(p.getName());
            String type = Toolkit.getType(p);
            param.setLastValue(this.getDefaultValueForType(type));
            param.setType(Toolkit.getType(p));
            for (Property prop : pa.getProperties()) {
                String key = prop.getKey();
                String value = ScriptFactory.removeQuotes(this.propertyValuetoString(prop.getValue()));
                param.setProperty(key, value);
                if (!"value".equals(key)) continue;
                param.setLastValue(value);
            }
            return param;
        }
        return null;
    }

    private String getDefaultValueForType(String type) {
        if ("boolean".equals(type)) {
            return "true";
        }
        if ("string".equals(type)) {
            return "";
        }
        return "0";
    }

    private String propertyValuetoString(EObject value) {
        return this.objectToCode(value);
    }

    public static String getParameterName(ParameterDeclaration pd) {
        String name = pd.getName();
        if (pd.getLabel() != null) {
            name = pd.getLabel().getValue();
        }
        return name;
    }

    private void addProbeSet(TemplateDeclaration t, TemplateDescriptor td, ScriptModel script) throws ParseException {
        for (ProbeAssignment pa : t.getProbeAssignments()) {
            Probe p = this.createProbe(pa.getProbe(), script);
            if (p == null) continue;
            td.getProbes().add(p);
        }
        for (ProbeSetAssignment psa : t.getProbeSetAssignments()) {
            ProbeSet ps = this.createProbeSet(psa, script);
            if (ps == null) continue;
            td.getProbeSets().add(ps);
        }
    }

    private ProbeSet createProbeSet(ProbeSetAssignment pa, ScriptModel script) throws ParseException {
        ProbeSetDeclaration p = pa.getProbeset();
        if (p != null && p.getName() != null) {
            ProbeSet ps = new ProbeSet();
            String enabled = String.valueOf(Toolkit.getPropertyValue((EList<Property>)pa.getProperties(), "enabled"));
            ps.setEnabled(Boolean.TRUE.toString().equalsIgnoreCase(enabled));
            ps.setName(Toolkit.getProbeSetName(p));
            this.addProbes(ps, p, script);
            return ps;
        }
        return null;
    }

    private void addProbes(ProbeSet ps, ProbeSetDeclaration psd, ScriptModel script) throws ParseException {
        for (ProbeDeclaration p : psd.getProbes()) {
            Probe probe = this.createProbe(p, script);
            if (probe == null) continue;
            ps.getProbes().add(probe);
        }
    }

    private Probe createProbe(ProbeDeclaration p, ScriptModel script) throws ParseException {
        if (p.getName() != null) {
            Probe probe = new Probe();
            probe.setIdentifier(p.getName());
            Integer index = this.sequenceMap.get(p);
            probe.setSequenceNumber(index);
            String code = this.extractCode(p, script);
            if (code != null) {
                probe.setCode(code);
                this.addVariables(probe, code);
            }
            return probe;
        }
        return null;
    }

    private void addVariables(Probe probe, String code) {
        boolean insideQuotes = false;
        char[] chars = code.toCharArray();
        String currentVariable = null;
        int n = 0;
        while (n < chars.length - 1) {
            char c = chars[n];
            if (currentVariable != null) {
                if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-') {
                    currentVariable = String.valueOf(currentVariable) + c;
                } else {
                    if (currentVariable.length() > 0) {
                        Variable v = new Variable();
                        v.setName(currentVariable);
                        probe.getVariables().add(v);
                    }
                    currentVariable = null;
                }
            }
            if (c == '\"') {
                boolean bl = insideQuotes = !insideQuotes;
            }
            if (!insideQuotes && c == '$') {
                currentVariable = "";
            }
            ++n;
        }
    }

    private String extractCode(ProbeDeclaration pd, ScriptModel script) throws ParseException {
        StringBuffer sb = new StringBuffer();
        int probeCount = pd.getProbes().size();
        int i = 0;
        while (i < probeCount) {
            sb.append((String)pd.getProbes().get(i));
            if (i < probeCount - 1) {
                sb.append(',');
            }
            sb.append('\n');
            ++i;
        }
        if (pd.getPredicare() != null) {
            sb.append(String.valueOf(pd.getPredicare().toString().trim()) + '\n');
        }
        sb.append("{\n");
        for (Statement s : pd.getStatements()) {
            if (s instanceof EventStatement) {
                sb.append(String.valueOf('\t') + this.eventStatementToCode(script, (EventStatement)s).trim());
                sb.append('\n');
                continue;
            }
            sb.append(String.valueOf('\t') + this.objectToCode((EObject)s).trim() + ';');
            sb.append('\n');
        }
        sb.append("}\n");
        return sb.toString();
    }

    private String eventStatementToCode(ScriptModel script, EventStatement s) {
        EventTypeDescriptor etd = this.m_producerDescriptor.lookupEventType(s.getName().getName());
        String formatters = "%d " + this.createToken(s.getCommand(), etd) + ' ';
        String values = " timestamp ";
        for (FieldDescriptor f : etd.getFields()) {
            for (Property prop : s.getListOfArgs()) {
                if (!prop.getKey().equals(f.getIdentifier())) continue;
                formatters = f.getDataType().equals("string") ? String.valueOf(formatters) + "\\\"%s\\\" " : String.valueOf(formatters) + "%d ";
                values = String.valueOf(values) + ", " + ScriptFactory.removeQuotes(this.objectToCode(prop.getValue()).trim());
            }
        }
        return "printf(\"" + formatters.trim() + "\\n\", " + values + ");";
    }

    private String createToken(EventCommandType command, EventTypeDescriptor etd) {
        if (command == EventCommandType.BEGIN) {
            return String.valueOf(etd.getIdentifier()) + "...";
        }
        if (command == EventCommandType.END) {
            return String.valueOf(etd.getIdentifier()) + '!';
        }
        return String.valueOf(etd.getIdentifier()) + '!';
    }

    private String objectToCode(EObject e) {
        ICompositeNode cn = NodeModelUtils.getNode((EObject)e);
        if (cn != null) {
            int totalLength = cn.getTotalLength();
            int totalOffset = cn.getTotalOffset();
            return this.m_sourceCode.substring(totalOffset, totalOffset + totalLength).trim();
        }
        return "";
    }

    private static String removeQuotes(String text) {
        if (text.startsWith("\"") && text.endsWith("\"")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }
}

