/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.dtrace.events.code.EventTypeDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ProducerDescriptor {
    private static final String URI = "uri";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String EVENT_TYPES = "eventTypes";
    private final Setting m_setting = new Setting("producer");
    private final Map<String, EventTypeDescriptor> m_cache = new HashMap<String, EventTypeDescriptor>();

    static {
        PersistenceToolkit.registerFetcher(ProducerDescriptor.class, (ISettingFetcher)new ISettingFetcher<ProducerDescriptor>(){

            public Setting getSetting(ProducerDescriptor eventTypeDescriptor) {
                return eventTypeDescriptor.m_setting;
            }
        });
    }

    public String getURI() {
        return (String)this.m_setting.getChildObject(URI, String.class);
    }

    public String getDescription() {
        return (String)this.m_setting.getChildObject(DESCRIPTION, String.class);
    }

    public String getName() {
        return (String)this.m_setting.getChildObject(NAME, String.class);
    }

    public List<EventTypeDescriptor> getEventTypes() {
        return (List)this.m_setting.getChildObject("producers", new Type(List.class, new Type[]{new Type(EventTypeDescriptor.class)}));
    }

    public void setURI(String uri) {
        this.m_setting.setChildObject(URI, (Object)uri);
    }

    public void setName(String name) {
        this.m_setting.setChildObject(NAME, (Object)name);
    }

    public void setDescription(String description) {
        this.m_setting.setChildObject(DESCRIPTION, (Object)description);
    }

    public List<EventTypeDescriptor> getEventTypeDesciptors() {
        return (List)this.m_setting.getChildObject(EVENT_TYPES, new Type(List.class, new Type[]{new Type(EventTypeDescriptor.class)}));
    }

    public EventTypeDescriptor lookupEventType(String identifier) {
        EventTypeDescriptor etd = this.m_cache.get(identifier);
        if (etd == null) {
            for (EventTypeDescriptor e : this.getEventTypeDesciptors()) {
                this.m_cache.put(e.getIdentifier(), e);
            }
            return this.m_cache.get(identifier);
        }
        return etd;
    }
}

