/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.dtrace.events.code.Probe;
import java.util.List;

public final class ProbeSet {
    private static final String IDENTIFIER = "identifier";
    private static final String NAME = "name";
    private static final String ENABLED = "enabled";
    private final String PROBES = "probes";
    private final Setting m_setting = new Setting("probeSet");

    static {
        PersistenceToolkit.registerFetcher(ProbeSet.class, (ISettingFetcher)new ISettingFetcher<ProbeSet>(){

            public Setting getSetting(ProbeSet c) {
                return c.m_setting;
            }
        });
    }

    public List<Probe> getProbes() {
        return (List)this.m_setting.getChildObject("probes", new Type(List.class, new Type[]{new Type(Probe.class)}));
    }

    boolean hasVariable(String identifier) {
        for (Probe p : this.getProbes()) {
            if (!p.hasVariable(identifier)) continue;
            return true;
        }
        return false;
    }

    public void setIdentifier(String id) {
        this.m_setting.setChildObject(IDENTIFIER, (Object)id);
    }

    public void setName(String name) {
        this.m_setting.setChildObject(NAME, (Object)name);
    }

    public String getName() {
        return (String)this.m_setting.getChildObject(NAME, String.class);
    }

    public boolean isEnabled() {
        return (Boolean)this.m_setting.getChildObject(ENABLED, Boolean.class);
    }

    public void setEnabled(boolean enabled) {
        this.m_setting.setChildObject(ENABLED, (Object)enabled);
    }
}

