/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

import com.jrockit.mc.dtrace.events.code.EventTypeDescriptor;
import com.jrockit.mc.dtrace.events.code.FieldDescriptor;
import com.jrockit.mc.dtrace.events.code.IProgress;
import com.jrockit.mc.dtrace.events.code.MCColor;
import com.jrockit.mc.dtrace.events.code.Metadata;
import com.jrockit.mc.dtrace.events.code.ProducerDescriptor;
import com.jrockit.mc.dtrace.events.code.Toolkit;
import com.jrockit.mc.dtrace.language.dEL.Color;
import com.jrockit.mc.dtrace.language.dEL.ColorAnnotation;
import com.jrockit.mc.dtrace.language.dEL.DescriptionAnnotation;
import com.jrockit.mc.dtrace.language.dEL.EventDeclaration;
import com.jrockit.mc.dtrace.language.dEL.FieldDeclaration;
import com.jrockit.mc.dtrace.language.dEL.LabelAnnotation;
import com.jrockit.mc.dtrace.language.dEL.PathAnnotation;
import com.jrockit.mc.dtrace.language.dEL.Program;
import com.jrockit.mc.dtrace.language.dEL.RGB;
import com.jrockit.mc.dtrace.language.dEL.TypeAnnotation;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.eclipse.emf.ecore.EObject;

final class MetadataBuilder {
    private static final String JAVA_TIME = "javaTime";
    private static final String DTRACE_TIME = "dtraceTime";

    MetadataBuilder() {
    }

    public Metadata createMetadata(Program p, Metadata metadata, IProgress progress) {
        ProducerDescriptor prod = this.createProducer();
        metadata.getProducers().add(prod);
        progress.beginTask("Building event types");
        prod.getEventTypeDesciptors().add(this.createRecordingEvent());
        for (EventDeclaration e : Toolkit.getAllChildrenDFS((EObject)p, EventDeclaration.class)) {
            prod.getEventTypeDesciptors().add(MetadataBuilder.createEventTypeDescriptor(e));
        }
        progress.endTask();
        return metadata;
    }

    private EventTypeDescriptor createRecordingEvent() {
        EventTypeDescriptor type = new EventTypeDescriptor();
        type.setName("Recording");
        type.setPath("Recording/recording");
        type.setDescription("Information about the recording");
        type.setIdentifier("Recording");
        type.setColor(new MCColor(125, 34, 12));
        FieldDescriptor startTime1 = new FieldDescriptor();
        startTime1.setName("DTrace Start Time");
        startTime1.setDescription("The start time of the recording in dtrace time");
        startTime1.setIdentifier(DTRACE_TIME);
        startTime1.setBeginValue(true);
        startTime1.setDataType("long");
        type.getFields().add(startTime1);
        FieldDescriptor startTime2 = new FieldDescriptor();
        startTime2.setName("Millis since 1970");
        startTime2.setDescription("The start time of the recording in millis since 1970");
        startTime2.setIdentifier(JAVA_TIME);
        startTime2.setBeginValue(true);
        startTime2.setDataType("long");
        type.getFields().add(startTime2);
        FieldDescriptor expectedRecordingTime = new FieldDescriptor();
        expectedRecordingTime.setName("Expected Recording Time");
        expectedRecordingTime.setDescription("The expected recording time");
        expectedRecordingTime.setIdentifier("expectedRecordingTime");
        expectedRecordingTime.setContentType("timespan");
        expectedRecordingTime.setBeginValue(true);
        expectedRecordingTime.setDataType("long");
        type.getFields().add(expectedRecordingTime);
        return type;
    }

    private ProducerDescriptor createProducer() {
        ProducerDescriptor p = new ProducerDescriptor();
        p.setName("DTrace Events");
        p.setURI("http://www.oracle.com/dtrace-events");
        p.setDescription("Events produced by DTrace");
        return p;
    }

    private static EventTypeDescriptor createEventTypeDescriptor(EventDeclaration e) {
        EventTypeDescriptor etd = new EventTypeDescriptor();
        MetadataBuilder.setEventTypeName(e, etd);
        MetadataBuilder.setEventTypeIdentifier(e, etd);
        MetadataBuilder.setEventTypeDescription(e, etd);
        MetadataBuilder.setEventTypePath(e, etd);
        for (FieldDeclaration field : MetadataBuilder.getFields(e)) {
            etd.getFields().add(MetadataBuilder.createFieldDescriptor(field));
        }
        MetadataBuilder.setEventTypeColor(e, etd);
        return etd;
    }

    private static void setEventTypeColor(EventDeclaration e, EventTypeDescriptor etd) {
        Color c;
        ColorAnnotation ca = e.getColor();
        if (ca != null && (c = ca.getColor()) instanceof RGB) {
            RGB r = (RGB)c;
            int red = r.getRed();
            int green = r.getGreen();
            int blue = r.getBlue();
            etd.setColor(new MCColor(red, green, blue));
        }
    }

    private static void setEventTypeIdentifier(EventDeclaration e, EventTypeDescriptor etd) {
        etd.setIdentifier(e.getName());
    }

    private static void setEventTypePath(EventDeclaration e, EventTypeDescriptor etd) {
        PathAnnotation path = e.getPath();
        if (path != null && path.getValue() != null) {
            etd.setPath(path.getValue());
        }
    }

    private static Collection<FieldDeclaration> getFields(EventDeclaration e) {
        LinkedHashMap<String, FieldDeclaration> fieldLookup = new LinkedHashMap<String, FieldDeclaration>();
        for (FieldDeclaration field : Toolkit.getAllChildrenDFS((EObject)e, FieldDeclaration.class)) {
            String name = field.getName();
            if (fieldLookup.containsKey(name)) continue;
            fieldLookup.put(name, field);
        }
        return fieldLookup.values();
    }

    private static void setEventTypeDescription(EventDeclaration e, EventTypeDescriptor etd) {
        DescriptionAnnotation description = e.getDescription();
        String descriptionString = e.getName();
        if (description != null && description.getValue() != null) {
            descriptionString = description.getValue();
        }
        etd.setDescription(descriptionString);
    }

    private static void setEventTypeName(EventDeclaration e, EventTypeDescriptor etd) {
        LabelAnnotation label = e.getLabel();
        String nameString = e.getName();
        if (label != null && label.getValue() != null) {
            nameString = label.getValue();
        }
        etd.setName(nameString);
    }

    private static FieldDescriptor createFieldDescriptor(FieldDeclaration field) {
        FieldDescriptor fieldDescriptor = new FieldDescriptor();
        MetadataBuilder.setFieldIdentifier(field, fieldDescriptor);
        MetadataBuilder.setFieldName(field, fieldDescriptor);
        MetadataBuilder.setFieldDescription(field, fieldDescriptor);
        MetadataBuilder.setFieldType(field, fieldDescriptor);
        MetadataBuilder.setFieldDescriptor(field, fieldDescriptor);
        return fieldDescriptor;
    }

    private static void setFieldDescriptor(FieldDeclaration field, FieldDescriptor fieldDescriptor) {
        fieldDescriptor.setDataType(field.getDataType());
    }

    private static void setFieldIdentifier(FieldDeclaration field, FieldDescriptor fieldDescriptor) {
        fieldDescriptor.setIdentifier(field.getName());
    }

    private static void setFieldType(FieldDeclaration field, FieldDescriptor fieldDescriptor) {
        TypeAnnotation type = field.getType();
        if (type != null && type.getValue() != null) {
            fieldDescriptor.setContentType(type.getValue());
        }
    }

    private static void setFieldDescription(FieldDeclaration field, FieldDescriptor fieldDescriptor) {
        DescriptionAnnotation description = field.getDescription();
        if (description != null && description.getValue() != null) {
            fieldDescriptor.setDescription(description.getValue());
        }
    }

    private static void setFieldName(FieldDeclaration field, FieldDescriptor fieldDescriptor) {
        LabelAnnotation label = field.getLabel();
        if (label != null && label.getValue() != null) {
            fieldDescriptor.setName(label.getValue());
        }
    }
}

