/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.dtrace.events.code.IProgress;
import com.jrockit.mc.dtrace.language.DELStandaloneSetup;
import com.jrockit.mc.dtrace.language.dEL.Program;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

final class Compiler {
    Compiler() {
    }

    Program compile(IProgress progress, String source) {
        Program p = null;
        progress.beginTask("Compiling");
        try {
            p = this.compileWIthException(progress, source);
        }
        catch (IOException e) {
            progress.addError("Error creating temporary compilation file. " + e.getMessage());
        }
        progress.endTask();
        return p;
    }

    private Program compileWIthException(IProgress progress, String source) throws IOException {
        DELStandaloneSetup.doSetup();
        ResourceSetImpl rs = new ResourceSetImpl();
        File temp = File.createTempFile("compilation", ".de");
        FileWriter fw = null;
        try {
            fw = new FileWriter(temp);
            fw.write(source);
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(fw);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)fw);
        Resource resource = rs.getResource(URI.createURI((String)temp.toURI().toString()), true);
        if (!temp.delete()) {
            Logger.getLogger("com.jrockit.mc.dtrace.events").severe(String.format("Could not delete temporary file %s", temp.toString()));
        }
        for (Resource.Diagnostic d : resource.getErrors()) {
            progress.addError(d.getMessage());
        }
        return progress.hasErrors() ? null : (Program)resource.getContents().get(0);
    }
}

