/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

import com.jrockit.mc.dtrace.events.code.AbstractCode;
import com.jrockit.mc.dtrace.events.code.IProgress;
import com.jrockit.mc.dtrace.events.code.Parameter;
import com.jrockit.mc.dtrace.events.code.Probe;
import com.jrockit.mc.dtrace.events.code.ProbeSet;
import com.jrockit.mc.dtrace.events.code.ScriptModel;
import com.jrockit.mc.dtrace.events.code.TemplateDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CodeGenerator {
    private final ScriptModel m_script;
    private final PrintWriter m_out;

    public CodeGenerator(ScriptModel script, PrintWriter pw) {
        this.m_script = script;
        this.m_out = pw;
    }

    public boolean generate(IProgress progress) {
        if (!progress.hasErrors()) {
            List<TemplateDescriptor> enabled = this.findSelectedTemplates(this.m_script);
            if (enabled.size() == 0) {
                progress.addError("No tempate enabled for code generation.");
            }
            if (enabled.size() > 1) {
                progress.addError("Only one template can be enabled when generating code.");
            }
            if (enabled.size() == 1) {
                this.printCode(this.m_script, enabled.get(0));
                return true;
            }
        }
        return false;
    }

    private List<TemplateDescriptor> findSelectedTemplates(ScriptModel script) {
        ArrayList<TemplateDescriptor> enabled = new ArrayList<TemplateDescriptor>();
        for (TemplateDescriptor t : script.getTemplates()) {
            if (!t.isSelected()) continue;
            enabled.add(t);
        }
        return enabled;
    }

    private void printCode(ScriptModel script, TemplateDescriptor t) {
        ArrayList<AbstractCode> codeFragements = new ArrayList<AbstractCode>();
        codeFragements.addAll(script.getDTraceCode());
        for (ProbeSet ps : t.getProbeSets()) {
            if (!ps.isEnabled()) continue;
            for (Probe p : ps.getProbes()) {
                codeFragements.add(p);
            }
        }
        for (Probe p : t.getProbes()) {
            codeFragements.add(p);
        }
        Collections.sort(codeFragements);
        for (AbstractCode as : codeFragements) {
            String code = as.getCode();
            code = this.substituteVariables(code, t.getParameters());
            this.writeLine(code);
        }
        int recordingTimeSeconds = (int)Math.max(1L, Long.parseLong(t.getRecordingTime().getLastValue()) / 1000000000L);
        this.writeBeginAndEnd(recordingTimeSeconds);
    }

    public void writeBeginAndEnd(int recordingTime) {
        this.writeBeginProbe(recordingTime);
        this.writeCountDownProbe();
        this.writeExitProbe();
        this.writeEndProbe();
    }

    private void writeBeginProbe(int seconds) {
        this.writeLine("dtrace:::BEGIN");
        this.writeLine("{");
        this.writeLine("  timeout = " + seconds + ";");
        this.writeLine("  printf(\"0 Recording... %d " + 1000000L * System.currentTimeMillis() + ' ' + (long)seconds * 1000000000L + "\\n\", timestamp);");
        this.writeLine("}");
        this.writeLine("");
    }

    private void writeEndProbe() {
        this.writeLine("dtrace:::END");
        this.writeLine("{");
        this.writeLine("   printf(\"%d Recording!\\n\", timestamp);");
        this.writeLine("}");
        this.writeLine("");
    }

    private void writeCountDownProbe() {
        this.writeLine("profile:::tick-1s");
        this.writeLine("/ timeout != 0 /");
        this.writeLine("{");
        this.writeLine("   this->count++;");
        this.writeLine("}");
        this.writeLine("");
    }

    private void writeExitProbe() {
        this.writeLine("profile:::tick-1s");
        this.writeLine("/  timeout != 0 && this->count >= timeout /");
        this.writeLine("{");
        this.writeLine("   exit(0);");
        this.writeLine("}");
        this.writeLine("");
    }

    private void writeLine(String line) {
        this.m_out.println(line);
    }

    private String substituteVariables(String code, List<Parameter> parameters) {
        for (Parameter p : parameters) {
            String identifier = p.getidentifier();
            if (identifier.equals("recordingTime")) continue;
            String value = p.getLastValue();
            code = code.replace(String.valueOf('$') + identifier, value);
        }
        return code;
    }
}

