/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.events.code;

import com.jrockit.mc.dtrace.events.code.EventTypeDescriptor;
import com.jrockit.mc.dtrace.events.code.FieldDescriptor;
import com.jrockit.mc.dtrace.events.code.Metadata;
import com.jrockit.mc.dtrace.events.code.ProducerDescriptor;
import com.jrockit.mc.dtrace.language.dEL.CodeFragment;
import com.jrockit.mc.dtrace.language.dEL.EventCommandType;
import com.jrockit.mc.dtrace.language.dEL.EventStatement;
import com.jrockit.mc.dtrace.language.dEL.ProbeDeclaration;
import com.jrockit.mc.dtrace.language.dEL.Program;
import com.jrockit.mc.dtrace.language.dEL.Property;
import com.jrockit.mc.dtrace.language.dEL.Statement;

public class BeginEndAnnotater {
    private final Metadata m_metadata;
    private final Program m_program;

    BeginEndAnnotater(Metadata metadata, Program program) {
        this.m_metadata = metadata;
        this.m_program = program;
    }

    void annotate() {
        for (ProducerDescriptor p : this.m_metadata.getProducers()) {
            this.annotate(p);
        }
    }

    private void annotate(ProducerDescriptor producer) {
        for (CodeFragment cf : this.m_program.getCodeFragments()) {
            if (!(cf instanceof ProbeDeclaration)) continue;
            ProbeDeclaration probeDeclaration = (ProbeDeclaration)cf;
            for (Statement statement : probeDeclaration.getStatements()) {
                EventStatement es;
                EventTypeDescriptor etd;
                if (!(statement instanceof EventStatement) || (etd = producer.lookupEventType((es = (EventStatement)statement).getName().getName())) == null) continue;
                for (Property p : es.getListOfArgs()) {
                    FieldDescriptor f = etd.getField(p.getKey());
                    if (es.getCommand() == EventCommandType.BEGIN) {
                        f.setBeginValue(true);
                    }
                    if (es.getCommand() != EventCommandType.END) continue;
                    f.setEndValue(true);
                }
            }
        }
    }
}

