/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.util;

import com.oracle.joverflow.util.ValueWithIntId;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ValueWitIntIdMap<V extends ValueWithIntId> {
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private V[] values;
    private int size;
    private int capacity;
    private int threshold;
    volatile Collection<V> valuesCollectionView = null;
    private long rehashTime;

    public ValueWitIntIdMap(int expectedMaxSize) {
        int minCapacity = 3 * expectedMaxSize / 2;
        if (minCapacity > 0x20000000 || minCapacity < 0) {
            this.capacity = 0x20000000;
        } else {
            this.capacity = 4;
            while (this.capacity < minCapacity) {
                this.capacity <<= 1;
            }
        }
        this.createTable();
    }

    public void put(V value) {
        int key = value.getId();
        int idx = this.hash(key);
        while (this.values[idx] != null) {
            if (this.values[idx].getId() == key) {
                this.values[idx] = value;
                return;
            }
            idx = (idx + 1) % this.capacity;
        }
        this.values[idx] = value;
        ++this.size;
        if (this.size > this.threshold) {
            this.rehash();
        }
    }

    public V get(int key) {
        int idx = this.hash(key);
        while (this.values[idx] != null) {
            if (this.values[idx].getId() == key) {
                return this.values[idx];
            }
            idx = (idx + 1) % this.capacity;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public Collection<V> values() {
        Values vs = this.valuesCollectionView;
        return vs != null ? vs : (this.valuesCollectionView = new Values());
    }

    private int hash(int v) {
        return (v << 1) - (v << 8) & this.capacity - 1;
    }

    private void rehash() {
        if (this.capacity == 0x20000000) {
            return;
        }
        long time = System.currentTimeMillis();
        V[] oldValues = this.values;
        this.capacity <<= 1;
        this.createTable();
        int i = 0;
        while (i < oldValues.length) {
            if (oldValues[i] != null) {
                this.put(oldValues[i]);
            }
            ++i;
        }
        this.rehashTime += System.currentTimeMillis() - time;
    }

    private void createTable() {
        this.threshold = this.capacity / 4 * 3;
        this.size = 0;
        this.values = new ValueWithIntId[this.capacity];
    }

    public long getRehashTimeMillis() {
        return this.rehashTime;
    }

    private final class ValueIterator
    implements Iterator<V> {
        private V next;
        private int index;

        ValueIterator() {
            if (ValueWitIntIdMap.this.size > 0) {
                ValueWithIntId[] t = ValueWitIntIdMap.this.values;
                while (this.index < t.length && (this.next = t[this.index]) == null) {
                    ++this.index;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            Object v = this.next;
            if (v == null) {
                throw new NoSuchElementException();
            }
            this.next = null;
            ++this.index;
            ValueWithIntId[] t = ValueWitIntIdMap.this.values;
            while (this.index < t.length && (this.next = t[this.index]) == null) {
                ++this.index;
            }
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ValueWitIntIdMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

