/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.util;

import java.lang.ref.WeakReference;

public class StringInterner {
    private static final WeakReference<String>[] table;
    private static int size;
    private static final int threshold;
    private static volatile int numCalls;
    private static volatile int numResets;

    static {
        int length = (int)(Runtime.getRuntime().totalMemory() / 100L / 100L);
        length = Integer.highestOneBit(length);
        table = new WeakReference[length];
        threshold = length * 3 / 4;
    }

    public static String internString(String s) {
        WeakReference<String> entry;
        if (s == null) {
            return null;
        }
        ++numCalls;
        int index = s.hashCode();
        index = StringInterner.hash(index);
        index &= table.length - 1;
        int gapIdx = -1;
        while ((entry = table[index]) != null) {
            String cachedValue = (String)entry.get();
            if (cachedValue == null) {
                if (gapIdx == -1) {
                    gapIdx = index;
                }
                index = index + 1 & table.length - 1;
                continue;
            }
            if (cachedValue.equals(s)) {
                return cachedValue;
            }
            index = index + 1 & table.length - 1;
        }
        if (size > threshold && gapIdx == -1) {
            int i = 0;
            while (i < table.length) {
                StringInterner.table[i] = null;
                ++i;
            }
            size = 0;
            ++numResets;
        }
        if (gapIdx != -1) {
            index = gapIdx;
        } else {
            ++size;
        }
        StringInterner.table[index] = new WeakReference<String>(s);
        return s;
    }

    public static Object internStringInObjectRef(Object obj) {
        if (!(obj instanceof String)) {
            return obj;
        }
        return StringInterner.internString((String)obj);
    }

    public static String[] internStringArrayContents(String[] arr) {
        if (arr == null) {
            return null;
        }
        int i = 0;
        while (i < arr.length) {
            String result = StringInterner.internString(arr[i]);
            if (result != null) {
                arr[i] = result;
            }
            ++i;
        }
        return arr;
    }

    public static Object[] internStringsInObjectArray(Object[] arr) {
        if (arr == null) {
            return null;
        }
        int i = 0;
        while (i < arr.length) {
            Object result = StringInterner.internStringInObjectRef(arr[i]);
            if (result != null) {
                arr[i] = result;
            }
            ++i;
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printInternStats() {
        int numNullEntries = 0;
        WeakReference<String>[] weakReferenceArray = table;
        synchronized (table) {
            WeakReference<String>[] weakReferenceArray2 = table;
            int n = table.length;
            int n2 = 0;
            while (n2 < n) {
                WeakReference<String> tableEntry = weakReferenceArray2[n2];
                if (tableEntry == null) {
                    ++numNullEntries;
                }
                ++n2;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            System.out.println("Table size: " + table.length + ", null entries: " + numNullEntries);
            System.out.println("Num calls (may be off due to overflowing): " + numCalls);
            System.out.println("Num resets: " + numResets);
            return;
        }
    }

    private static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }
}

