/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.util;

import java.util.Arrays;

public class SmallSet<V> {
    Object[] elements;

    public SmallSet() {
        this.elements = new Object[2];
    }

    public SmallSet(SmallSet<V> other) {
        this.elements = new Object[other.elements.length];
        System.arraycopy(other.elements, 0, this.elements, 0, other.elements.length);
    }

    public boolean add(V v) {
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i] == null) {
                this.elements[i] = v;
                return true;
            }
            if (this.elements[i].equals(v)) {
                return false;
            }
            ++i;
        }
        Object[] oldElements = this.elements;
        this.elements = new Object[oldElements.length + 2];
        System.arraycopy(oldElements, 0, this.elements, 0, oldElements.length);
        this.elements[oldElements.length] = v;
        return true;
    }

    public void addAll(SmallSet<V> other) {
        Object[] objectArray = other.elements;
        int n = other.elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            if (v == null) break;
            this.add(v);
            ++n2;
        }
    }

    public <T> T[] getElements(Class<T[]> arrayClass) {
        int count = this.elements.length;
        while (count > 0 && this.elements[count - 1] == null) {
            --count;
        }
        return Arrays.copyOf(this.elements, count, arrayClass);
    }
}

