/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.util;

public class SimpleIdentitySet<V> {
    private V[] table;
    private int size;
    private int threshold;
    private long rehashTime;

    public SimpleIdentitySet(int expectedObjNum) {
        int capacity = expectedObjNum * 4 / 3 + 3 | 1;
        this.createTable(capacity);
    }

    public boolean add(V v) {
        V vt;
        int idx = SimpleIdentitySet.hash(v.hashCode()) % this.table.length;
        while ((vt = this.table[idx]) != null) {
            if (vt == v) {
                return false;
            }
            idx = (idx + 1) % this.table.length;
        }
        this.table[idx] = v;
        ++this.size;
        if (this.size > this.threshold) {
            this.rehash();
        }
        return true;
    }

    public boolean contains(V v) {
        V vt;
        int idx = SimpleIdentitySet.hash(v.hashCode()) % this.table.length;
        while ((vt = this.table[idx]) != null) {
            if (vt == v) {
                return true;
            }
            idx = (idx + 1) % this.table.length;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public long getRehashTimeMillis() {
        return this.rehashTime;
    }

    private static int hash(int h) {
        return h & Integer.MAX_VALUE;
    }

    private void rehash() {
        long time = System.currentTimeMillis();
        V[] oldTable = this.table;
        int capacity = this.table.length * 3 / 2 | 1;
        this.createTable(capacity);
        V[] VArray = oldTable;
        int n = oldTable.length;
        int n2 = 0;
        while (n2 < n) {
            V v = VArray[n2];
            if (v != null) {
                this.add(v);
            }
            ++n2;
        }
        this.rehashTime += System.currentTimeMillis() - time;
    }

    private void createTable(int capacity) {
        this.threshold = capacity / 4 * 3;
        this.size = 0;
        this.table = new Object[capacity];
    }
}

