/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.util;

public class SetOfLongs {
    private long[] table;
    private boolean[] occupied;
    private int size;
    private int capacity;
    private int threshold;

    public SetOfLongs(int initialCapacity) {
        this.capacity = initialCapacity | 1;
        this.createTable();
    }

    public boolean add(long v) {
        int idx = this.hash(v) % this.capacity;
        while (this.occupied[idx]) {
            if (this.table[idx] == v) {
                return false;
            }
            idx = (idx + 1) % this.capacity;
        }
        this.table[idx] = v;
        this.occupied[idx] = true;
        ++this.size;
        if (this.size > this.threshold) {
            this.rehash();
        }
        return true;
    }

    public boolean contains(long v) {
        int idx = this.hash(v) % this.capacity;
        while (this.occupied[idx]) {
            if (this.table[idx] == v) {
                return true;
            }
            idx = (idx + 1) % this.capacity;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    private int hash(long v) {
        return (int)(v ^ v >>> 32) & Integer.MAX_VALUE;
    }

    private void rehash() {
        long[] oldTable = this.table;
        boolean[] oldOccupied = this.occupied;
        this.capacity = this.capacity * 3 / 2 | 1;
        this.createTable();
        int i = 0;
        while (i < oldTable.length) {
            if (oldOccupied[i]) {
                this.add(oldTable[i]);
            }
            ++i;
        }
    }

    private void createTable() {
        this.threshold = this.capacity / 4 * 3;
        this.size = 0;
        this.table = new long[this.capacity];
        this.occupied = new boolean[this.capacity];
    }
}

