/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.util;

import java.util.Arrays;
import java.util.Comparator;

public class ObjectToIntMap<K>
implements Cloneable {
    private K[] keys;
    private int[] values;
    private int size;
    private int capacity;
    private int threshold;
    private long rehashTime;

    public ObjectToIntMap(int initialCapacity) {
        this.capacity = initialCapacity | 1;
        this.createTable();
    }

    public void put(K key, int value) {
        int idx = this.hash(key) % this.capacity;
        while (this.keys[idx] != null) {
            if (this.keys[idx].equals(key)) {
                this.values[idx] = value;
                return;
            }
            idx = (idx + 1) % this.capacity;
        }
        this.keys[idx] = key;
        this.values[idx] = value;
        ++this.size;
        if (this.size > this.threshold) {
            this.rehash();
        }
    }

    public int get(K key) {
        int idx = this.hash(key) % this.capacity;
        while (this.keys[idx] != null) {
            if (this.keys[idx].equals(key)) {
                return this.values[idx];
            }
            idx = (idx + 1) % this.capacity;
        }
        return -1;
    }

    public void putOneOrIncrement(K key) {
        int idx = this.hash(key) % this.capacity;
        while (this.keys[idx] != null) {
            if (this.keys[idx].equals(key)) {
                int n = idx;
                this.values[n] = this.values[n] + 1;
                return;
            }
            idx = (idx + 1) % this.capacity;
        }
        this.keys[idx] = key;
        this.values[idx] = 1;
        ++this.size;
        if (this.size > this.threshold) {
            this.rehash();
        }
    }

    public void putOrIncrementBy(K key, int value) {
        int idx = this.hash(key) % this.capacity;
        while (this.keys[idx] != null) {
            if (this.keys[idx].equals(key)) {
                int n = idx;
                this.values[n] = this.values[n] + value;
                return;
            }
            idx = (idx + 1) % this.capacity;
        }
        this.keys[idx] = key;
        this.values[idx] = value;
        ++this.size;
        if (this.size > this.threshold) {
            this.rehash();
        }
    }

    public Entry<K>[] getEntries() {
        Entry[] result = new Entry[this.size];
        int entryIdx = 0;
        int i = 0;
        while (i < this.capacity) {
            if (this.keys[i] != null) {
                result[entryIdx++] = new Entry(this.keys[i], this.values[i]);
            }
            ++i;
        }
        return result;
    }

    public Entry<K>[] getEntriesSortedByValueThenKey() {
        Entry<K>[] result = this.getEntries();
        Arrays.sort(result, new Comparator<Entry<K>>(){

            @Override
            public int compare(Entry<K> e1, Entry<K> e2) {
                if (e1.value > e2.value) {
                    return -1;
                }
                if (e1.value < e2.value) {
                    return 1;
                }
                if (e1.key instanceof Comparable) {
                    return ((Comparable)e1.key).compareTo(e2.key);
                }
                return 0;
            }
        });
        return result;
    }

    public int size() {
        return this.size;
    }

    private int hash(K key) {
        return key.hashCode() & Integer.MAX_VALUE;
    }

    private void rehash() {
        long time = System.currentTimeMillis();
        K[] oldKeys = this.keys;
        int[] oldValues = this.values;
        this.capacity = this.capacity * 3 / 2 | 1;
        this.createTable();
        int i = 0;
        while (i < oldKeys.length) {
            if (oldKeys[i] != null) {
                this.put(oldKeys[i], oldValues[i]);
            }
            ++i;
        }
        this.rehashTime += System.currentTimeMillis() - time;
    }

    private void createTable() {
        this.threshold = this.capacity / 4 * 3;
        this.size = 0;
        this.keys = new Object[this.capacity];
        this.values = new int[this.capacity];
    }

    public long getRehashTimeMillis() {
        return this.rehashTime;
    }

    public ObjectToIntMap<K> clone() {
        try {
            return (ObjectToIntMap)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class Entry<K> {
        public K key;
        public int value;

        private Entry(K key, int value) {
            this.key = key;
            this.value = value;
        }
    }
}

