/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class NumberToObjectMap<V> {
    protected V[] values;
    protected int size;
    protected int capacity;
    protected int threshold;
    protected final boolean linked;
    protected int[] nextElement;
    protected int firstElementIdx;
    protected int prevAddedElementIdx;
    private volatile Collection<V> valuesCollectionView = null;
    protected long rehashTime;
    protected long numRehashes;

    protected NumberToObjectMap(int initialCapacity, boolean linked) {
        if (initialCapacity < 11) {
            initialCapacity = 11;
        }
        this.capacity = initialCapacity | 1;
        this.linked = linked;
        this.createTable();
    }

    public abstract void put(long var1, V var3);

    public abstract V get(long var1);

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public Collection<V> values() {
        Values vs = this.valuesCollectionView;
        return vs != null ? vs : (this.valuesCollectionView = new Values());
    }

    protected void finishPut(int idx) {
        if (this.linked) {
            if (this.prevAddedElementIdx == -1) {
                this.firstElementIdx = idx;
            } else {
                this.nextElement[this.prevAddedElementIdx] = idx;
                this.nextElement[idx] = -1;
            }
            this.prevAddedElementIdx = idx;
        }
        ++this.size;
        if (this.size > this.threshold) {
            this.rehash();
        }
    }

    protected abstract void rehash();

    protected abstract void createTable();

    public long getRehashTimeMillis() {
        return this.rehashTime;
    }

    public long getNumRehashes() {
        return this.numRehashes;
    }

    private final class LinkedValueIterator
    implements Iterator<V> {
        private int index;

        LinkedValueIterator() {
            this.index = NumberToObjectMap.this.firstElementIdx;
        }

        @Override
        public boolean hasNext() {
            return this.index != -1;
        }

        @Override
        public V next() {
            if (this.index == -1) {
                throw new NoSuchElementException();
            }
            Object v = NumberToObjectMap.this.values[this.index];
            this.index = NumberToObjectMap.this.nextElement[this.index];
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class ValueIterator
    implements Iterator<V> {
        private V next;
        private int index;

        ValueIterator() {
            if (NumberToObjectMap.this.size > 0) {
                V[] t = NumberToObjectMap.this.values;
                while (this.index < t.length && (this.next = t[this.index]) == null) {
                    ++this.index;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            Object v = this.next;
            if (v == null) {
                throw new NoSuchElementException();
            }
            this.next = null;
            ++this.index;
            V[] t = NumberToObjectMap.this.values;
            while (this.index < t.length && (this.next = t[this.index]) == null) {
                ++this.index;
            }
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return NumberToObjectMap.this.linked ? new LinkedValueIterator() : new ValueIterator();
        }

        @Override
        public int size() {
            return NumberToObjectMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

