/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.util;

import com.oracle.joverflow.util.NumberToObjectMap;

public class LongToObjectMap<V>
extends NumberToObjectMap<V> {
    private long[] keys;

    public LongToObjectMap(int initialCapacity, boolean linked) {
        super(initialCapacity, linked);
    }

    @Override
    public void put(long key, V value) {
        int idx = this.hash(key) % this.capacity;
        while (this.values[idx] != null) {
            if (this.keys[idx] == key) {
                this.values[idx] = value;
                return;
            }
            idx = (idx + 1) % this.capacity;
        }
        this.keys[idx] = key;
        this.values[idx] = value;
        this.finishPut(idx);
    }

    @Override
    public V get(long key) {
        int idx = this.hash(key) % this.capacity;
        while (this.values[idx] != null) {
            if (this.keys[idx] == key) {
                return (V)this.values[idx];
            }
            idx = (idx + 1) % this.capacity;
        }
        return null;
    }

    private int hash(long v) {
        return (int)(v ^ v >>> 32) & Integer.MAX_VALUE;
    }

    @Override
    protected void rehash() {
        long time = System.currentTimeMillis();
        long[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        int[] oldNextElement = this.nextElement;
        this.capacity = this.capacity * 3 / 2 | 1;
        this.createTable();
        if (this.linked) {
            int idx = this.firstElementIdx;
            while (idx != -1) {
                this.put(oldKeys[idx], oldValues[idx]);
                idx = oldNextElement[idx];
            }
        } else {
            int i = 0;
            while (i < oldKeys.length) {
                if (oldValues[i] != null) {
                    this.put(oldKeys[i], oldValues[i]);
                }
                ++i;
            }
        }
        this.rehashTime += System.currentTimeMillis() - time;
        ++this.numRehashes;
    }

    @Override
    protected void createTable() {
        this.threshold = this.capacity / 4 * 3;
        this.size = 0;
        this.keys = new long[this.capacity];
        this.values = new Object[this.capacity];
        if (this.linked) {
            this.nextElement = new int[this.capacity];
            this.prevAddedElementIdx = -1;
        }
    }
}

