/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.util;

import com.oracle.joverflow.util.NumberToIntMap;

public class IntToIntMap
extends NumberToIntMap {
    private int[] keys;

    public IntToIntMap(int expectedMaxSize) {
        super(expectedMaxSize);
    }

    @Override
    public void put(long key, int value) {
        int intKey = this.longKeyToIntKey(key);
        this.doPut(intKey, value);
    }

    private void doPut(int intKey, int value) {
        int idx = this.hash(intKey);
        while (this.values[idx] != -1) {
            if (this.keys[idx] == intKey) {
                this.throwCollisionException(intKey);
            }
            idx = this.nextKeyIndex(idx);
        }
        this.keys[idx] = intKey;
        this.values[idx] = value;
        this.finishPut();
    }

    @Override
    public int get(long key) {
        int intKey = this.longKeyToIntKey(key);
        int idx = this.hash(intKey);
        while (this.values[idx] != -1) {
            if (this.keys[idx] == intKey) {
                return this.values[idx];
            }
            idx = this.nextKeyIndex(idx);
        }
        return -1;
    }

    private int longKeyToIntKey(long key) {
        return (int)key | (int)(key >> 32) & 7;
    }

    private int hash(int h) {
        return (h &= Integer.MAX_VALUE) % this.capacity;
    }

    @Override
    protected void rehash(int newCapacity) {
        long time = System.currentTimeMillis();
        int[] oldKeys = this.keys;
        int[] oldValues = this.values;
        this.capacity = newCapacity;
        this.createTable();
        int i = 0;
        while (i < oldKeys.length) {
            if (oldValues[i] != -1) {
                this.doPut(oldKeys[i], oldValues[i]);
            }
            ++i;
        }
        this.rehashTime += System.currentTimeMillis() - time;
    }

    @Override
    protected void createTable() {
        this.threshold = this.capacity / 4 * 3;
        this.size = 0;
        this.keys = new int[this.capacity];
        this.values = new int[this.capacity];
        int i = 0;
        while (i < this.capacity) {
            this.values[i] = -1;
            ++i;
        }
    }

    private void throwCollisionException(int intKey) {
        throw new RuntimeException("Collision for intKey = " + Integer.toHexString(intKey) + ". Verify that IDs have 32 meaningful bits and/or that useOnlyLowWord was " + "set correctly.");
    }
}

