/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.util;

import java.util.Iterator;

public class IntArrayList
implements Iterable<Integer> {
    private static final int[] EMPTY_ARRAY = new int[0];
    private int[] array;
    private int size;

    public IntArrayList(int capacity) {
        this.array = new int[capacity];
    }

    public int get(int idx) {
        return this.array[idx];
    }

    public int size() {
        return this.size;
    }

    public void add(int value) {
        if (this.size == this.array.length) {
            int[] oldArray = this.array;
            this.array = new int[oldArray.length * 2];
            System.arraycopy(oldArray, 0, this.array, 0, oldArray.length);
        }
        this.array[this.size++] = value;
    }

    public boolean contains(int v) {
        int i = 0;
        while (i < this.size) {
            if (this.array[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int[] internalArray() {
        return this.array;
    }

    public int[] toArray() {
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        int[] result = new int[this.size];
        System.arraycopy(this.array, 0, result, 0, this.size);
        return result;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public IntArrayListIterator iterator() {
        return new IntArrayListIterator(this);
    }

    public static class IntArrayListIterator
    implements Iterator<Integer> {
        private final IntArrayList list;
        private int index;

        public IntArrayListIterator(IntArrayList setList) {
            this.list = setList;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0 && this.index < this.list.size();
        }

        @Override
        public Integer next() {
            return this.list.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

