/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.util;

import com.jrockit.mc.common.io.IOToolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static ArrayList<String> readTextFile(String fileName) throws IOException {
        return FileUtils.readTextFile(new File(fileName));
    }

    public static ArrayList<String> readTextFile(File file) throws IOException {
        FileReader reader = new FileReader(file);
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(reader);){
            String s;
            while ((s = br.readLine()) != null) {
                lines.add(s);
            }
        }
        return lines;
    }

    public static byte[] readBytesFromFile(String fileName) throws IOException {
        return FileUtils.readBytesFromFile(new File(fileName));
    }

    public static byte[] readBytesFromFile(File file) throws IOException {
        long longSize = file.length();
        if (longSize > Integer.MAX_VALUE) {
            throw new IOException("File length is " + longSize + ". Cannot read files longer than " + Integer.MAX_VALUE);
        }
        int size = (int)longSize;
        byte[] result = new byte[size];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            int readBytes = 0;
            while (readBytes < size) {
                readBytes += in.read(result, readBytes, size - readBytes);
            }
        }
        return result;
    }

    public static void writeTextToFile(File file, List<String> lines) throws IOException {
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        for (String line : lines) {
            out.println(line);
        }
        out.close();
    }

    public static void writeBytesToFile(File file, byte[] bytes) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            out.write(bytes);
        }
        finally {
            IOToolkit.closeSilently((Closeable)out);
        }
    }

    public static File fileExistsAndReadableOrExit(String fileName) {
        try {
            return FileUtils.checkFileExistsAndReadable(fileName, false);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            System.exit(-1);
            return null;
        }
    }

    public static File dirExistsAndReadableOrExit(String dirName) {
        try {
            return FileUtils.checkFileExistsAndReadable(dirName, true);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            System.exit(-1);
            return null;
        }
    }

    public static File checkFileExistsAndReadable(String fileName, boolean isDirectory) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new IOException("File " + fileName + " does not exist");
        }
        if (isDirectory) {
            if (!file.isDirectory()) {
                throw new IOException(String.valueOf(fileName) + " is not a directory");
            }
        } else if (!file.isFile()) {
            throw new IOException("File " + fileName + " is not a normal file");
        }
        if (!file.canRead()) {
            throw new IOException("File " + fileName + " cannot be read");
        }
        return file;
    }

    public static File dirExistsAndWritableOrExit(String dirName) {
        File dir = new File(dirName);
        if (!dir.exists()) {
            System.err.println("Directory " + dirName + " does not exist");
            System.exit(-1);
        }
        if (!dir.isDirectory()) {
            System.err.println("File " + dirName + " is not a directory");
            System.exit(-1);
        }
        if (!dir.canWrite()) {
            System.err.println("Directory " + dirName + " is not writable");
            System.exit(-1);
        }
        return dir;
    }

    public static File fileWritableOrExit(String fileName) {
        File f = new File(fileName);
        if (f.exists() && !f.isFile()) {
            System.err.println("File " + fileName + " is not a normal file");
            System.exit(-1);
        }
        if (f.exists() && !f.canWrite()) {
            System.err.println("File " + fileName + " is not writable");
            System.exit(-1);
        }
        try {
            FileOutputStream fo = new FileOutputStream(f);
            fo.close();
        }
        catch (IOException ex) {
            System.err.println("Cannot write to file " + fileName + ": " + ex.getMessage());
            System.exit(-1);
        }
        return f;
    }
}

